/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.richclient.javafx.dialog;

import java.text.DecimalFormat;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Window;
import net.sourceforge.jbizmo.commons.richclient.format.FormatDTO;
import net.sourceforge.jbizmo.commons.richclient.format.FormatPreferencesManager;
import net.sourceforge.jbizmo.commons.richclient.javafx.dialog.DialogButtonType;
import net.sourceforge.jbizmo.commons.richclient.javafx.dialog.TitleAreaDialog;
import net.sourceforge.jbizmo.commons.richclient.javafx.i18n.I18NJavaFX;
import net.sourceforge.jbizmo.commons.richclient.javafx.image.ImageLoader;
import net.sourceforge.jbizmo.commons.richclient.javafx.search.AbstractDataGridPanel;
import org.slf4j.Logger;

public abstract class AbstractLOVDialog<T>
extends TitleAreaDialog {
    protected FormatDTO userFormat = FormatPreferencesManager.getFormatDTO();
    protected DateTimeFormatter dateTimeFormat = DateTimeFormatter.ofPattern(this.userFormat.getDateTimeFormat()).withZone(ZoneId.systemDefault());
    protected DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern(this.userFormat.getDateFormat()).withZone(ZoneId.systemDefault());
    protected DecimalFormat decimalFormat = new DecimalFormat(this.userFormat.getDecimalFormat());
    protected TableView<T> tableView;
    protected TextField txtFilter;
    private AbstractDataGridPanel<T> gridPanel;
    private T selection;
    private String filterText;
    private boolean enableReset;

    public AbstractLOVDialog(Window owner, String title) {
        this(owner, title, false);
    }

    public AbstractLOVDialog(Window owner, String title, boolean enableReset) {
        super(owner, title);
        this.enableReset = enableReset;
        this.initModality(Modality.APPLICATION_MODAL);
    }

    protected abstract String getCellText(T var1, int var2);

    public abstract List<T> fetchData(String var1) throws Exception;

    public abstract ObservableList<TableColumn<T, String>> initColumns();

    protected abstract Logger getLogger();

    private void refresh() {
        this.gridPanel.refreshView();
    }

    private void onSelect() {
        this.selection = this.tableView.getSelectionModel().getSelectedItem();
        if (this.selection != null) {
            this.returnCode = DialogButtonType.OK;
            this.close();
        }
    }

    private void onReset() {
        this.selection = null;
        this.returnCode = DialogButtonType.RESET;
        this.close();
    }

    public T getSelection() {
        return this.selection;
    }

    @Override
    protected void onOKPressed() {
        this.onSelect();
    }

    @Override
    protected void createButtons() {
        super.createButtons();
        if (this.enableReset) {
            Button cmdReset = this.addButton(DialogButtonType.RESET, I18NJavaFX.getTranslation("cmd_reset"), false, false);
            cmdReset.setOnAction(e -> this.onReset());
        }
    }

    @Override
    protected Node createDialogArea() {
        this.getLogger().debug("Initialize dialog");
        this.setTitleImage(ImageLoader.getImage("window_lov_title.png"));
        this.setTitleMessage(I18NJavaFX.getTranslation("abstract_lov_dialog.title_message"));
        this.setInfoMessage(I18NJavaFX.getTranslation("abstract_lov_dialog.info_message"));
        VBox panDlg = new VBox();
        GridPane panFilter = new GridPane();
        panFilter.setHgap(5.0);
        panFilter.getColumnConstraints().add((Object)new ColumnConstraints(-1.0, -1.0, -1.0, Priority.SOMETIMES, HPos.LEFT, false));
        panFilter.getColumnConstraints().add((Object)new ColumnConstraints(-1.0, -1.0, -1.0, Priority.ALWAYS, HPos.LEFT, true));
        panFilter.add((Node)new Label(I18NJavaFX.getTranslationForFieldLabel("abstract_lov_dialog.lbl_filter")), 0, 0);
        this.txtFilter = new TextField();
        panFilter.add((Node)this.txtFilter, 1, 0);
        panFilter.setPadding(new Insets(0.0, 5.0, 0.0, 10.0));
        this.gridPanel = new AbstractDataGridPanel<T>((Window)this){

            @Override
            protected String getCellText(T element, int colIndex) {
                return AbstractLOVDialog.this.getCellText(element, colIndex);
            }

            @Override
            protected ObservableList<TableColumn<T, String>> initColumns() {
                return AbstractLOVDialog.this.initColumns();
            }

            @Override
            protected List<T> fetchData() throws Exception {
                return AbstractLOVDialog.this.fetchData(AbstractLOVDialog.this.filterText);
            }

            @Override
            protected void onDoubleClick(T item) {
                AbstractLOVDialog.this.onSelect();
            }

            @Override
            protected Logger getLogger() {
                return AbstractLOVDialog.this.getLogger();
            }
        };
        this.gridPanel.initialize();
        this.tableView = this.gridPanel.getTableView();
        MenuItem item = new MenuItem(I18NJavaFX.getTranslation("abstract_lov_dialog.select"));
        item.setOnAction(e -> this.onSelect());
        this.gridPanel.getContextMenu().getItems().add((Object)item);
        this.gridPanel.initActions();
        panDlg.getChildren().add((Object)panFilter);
        panDlg.getChildren().add(this.gridPanel);
        VBox.setVgrow(this.gridPanel, (Priority)Priority.ALWAYS);
        this.gridPanel.getTableView().getColumns().addAll(this.initColumns());
        this.txtFilter.textProperty().addListener((observable, oldValue, newValue) -> {
            this.filterText = newValue;
            if (this.filterText.isEmpty()) {
                this.gridPanel.getTableView().getItems().clear();
                this.gridPanel.getStatusBar().setText("");
                return;
            }
            this.refresh();
        });
        this.getLogger().debug("Dialog initialization finished");
        return panDlg;
    }
}

