/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.richclient.javafx.dialog;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import net.sourceforge.jbizmo.commons.richclient.javafx.dialog.DialogButtonType;
import net.sourceforge.jbizmo.commons.richclient.javafx.dialog.DialogUtil;
import net.sourceforge.jbizmo.commons.richclient.javafx.dialog.TitleAreaDialog;
import net.sourceforge.jbizmo.commons.richclient.javafx.i18n.I18NJavaFX;
import net.sourceforge.jbizmo.commons.richclient.javafx.image.ImageLoader;
import net.sourceforge.jbizmo.commons.richclient.logon.LogOnManager;
import net.sourceforge.jbizmo.commons.richclient.persistence.entity.LastLogOn;
import net.sourceforge.jbizmo.commons.richclient.transport.ServiceLocatorDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLogOnDialog
extends TitleAreaDialog {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int MAX_WRONG_INPUTS = 3;
    private TextField txtUserName;
    private PasswordField txtPassword;
    private int wrongInputCount;
    private ServiceLocatorDTO serviceLocatorDTO;
    private final HashMap<String, ServiceLocatorDTO> hostMap;
    private ComboBox<String> cboHost;
    private boolean hideHostSelection;

    public AbstractLogOnDialog(Window owner, HashMap<String, ServiceLocatorDTO> hostMap) {
        super(owner, I18NJavaFX.getTranslation("abstract_log_on_dialog.title"));
        this.hostMap = hostMap;
        if (hostMap.size() == 1) {
            this.hideHostSelection = true;
            this.setSize(340, 220);
        } else {
            this.setSize(340, 250);
        }
        this.serviceLocatorDTO = hostMap.values().stream().findFirst().orElse(null);
        this.initStyle(StageStyle.UTILITY);
    }

    public abstract void logOn(ServiceLocatorDTO var1);

    public ServiceLocatorDTO getServiceLocatorDTO() {
        return this.serviceLocatorDTO;
    }

    @Override
    protected Node createDialogArea() {
        LastLogOn lastLogOn;
        this.setTitleMessage(I18NJavaFX.getTranslation("abstract_log_on_dialog.title_message"));
        this.setTitleImage(ImageLoader.getImage("logon.png"));
        GridPane panRoot = new GridPane();
        panRoot.setHgap(5.0);
        panRoot.setVgap(5.0);
        panRoot.getColumnConstraints().add((Object)new ColumnConstraints(-1.0, -1.0, -1.0, Priority.SOMETIMES, HPos.LEFT, false));
        panRoot.getColumnConstraints().add((Object)new ColumnConstraints(-1.0, -1.0, -1.0, Priority.ALWAYS, HPos.LEFT, true));
        panRoot.add((Node)new Label(I18NJavaFX.getTranslationForFieldLabel("abstract_log_on_dialog.lbl_user_name")), 0, 0);
        this.txtUserName = new TextField();
        panRoot.add((Node)this.txtUserName, 1, 0);
        panRoot.add((Node)new Label(I18NJavaFX.getTranslationForFieldLabel("abstract_log_on_dialog.lbl_password")), 0, 1);
        this.txtPassword = new PasswordField();
        panRoot.add((Node)this.txtPassword, 1, 1);
        if (!this.hideHostSelection) {
            panRoot.add((Node)new Label(I18NJavaFX.getTranslationForFieldLabel("abstract_log_on_dialog.lbl_host")), 0, 2);
            this.cboHost = new ComboBox();
            panRoot.add((Node)this.cboHost, 1, 2);
            this.cboHost.getItems().addAll(this.hostMap.keySet());
            this.cboHost.setValue(this.hostMap.keySet().stream().findFirst().orElse(null));
        }
        if ((lastLogOn = LogOnManager.getLastLogOn()) != null) {
            this.txtUserName.setText(lastLogOn.getUserName());
            if (!this.hideHostSelection && this.hostMap.containsKey(lastLogOn.getHost())) {
                this.cboHost.setValue((Object)lastLogOn.getHost());
            }
        }
        return panRoot;
    }

    @Override
    protected void onOKPressed() {
        this.setReturnCode(DialogButtonType.CANCEL);
        if (this.txtUserName.getText().isEmpty()) {
            this.setErrorMessage(I18NJavaFX.getTranslation("abstract_log_on_dialog.msg_missing_user"));
            return;
        }
        if (!this.hideHostSelection) {
            this.serviceLocatorDTO = this.hostMap.get(this.cboHost.getValue());
        }
        this.serviceLocatorDTO.setUserName(this.txtUserName.getText());
        this.serviceLocatorDTO.setPassword(this.txtPassword.getText());
        try {
            this.logOn(this.serviceLocatorDTO);
            this.setReturnCode(DialogButtonType.OK);
            LogOnManager.saveLastLogOn((String)this.txtUserName.getText(), (String)this.serviceLocatorDTO.getAlias());
            this.close();
        }
        catch (SecurityException e) {
            logger.error("Login failed due to bad credentials!", (Throwable)e);
            ++this.wrongInputCount;
            this.setErrorMessage(I18NJavaFX.getTranslation("abstract_log_on_dialog.msg_invalid_credentials"));
            if (this.wrongInputCount == 3) {
                this.close();
            }
        }
        catch (Exception e) {
            logger.error("Login failed!", (Throwable)e);
            String title = I18NJavaFX.getTranslation("abstract_log_on_dialog.title_message");
            String message = I18NJavaFX.getTranslation("abstract_log_on_dialog.msg_connect_to_host");
            this.setErrorMessage(message);
            DialogUtil.openErrorDialog(null, title, message, e);
        }
    }
}

