/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.richclient.javafx.dialog;

import java.io.File;
import java.util.ArrayList;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.VBox;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import net.sourceforge.jbizmo.commons.file.ByteConverter;
import net.sourceforge.jbizmo.commons.richclient.javafx.dialog.AbstractBaseDialog;
import net.sourceforge.jbizmo.commons.richclient.javafx.dialog.DialogButtonType;
import net.sourceforge.jbizmo.commons.richclient.javafx.i18n.I18NJavaFX;
import net.sourceforge.jbizmo.commons.richclient.transport.ServiceLocator;
import net.sourceforge.jbizmo.commons.richclient.transport.event.DataProcessedEventController;
import net.sourceforge.jbizmo.commons.richclient.transport.event.DataProcessedListener;

public class FileDownloadDialog
extends AbstractBaseDialog
implements DataProcessedListener {
    private final File targetFile;
    private final String serverFilePath;
    private ProgressBar progressBar;
    private Label lblMessage;
    private Task<Void> downloadTask;
    private Throwable exception;

    public FileDownloadDialog(Window owner, String serverFilePath, File targetFile) {
        super(owner, I18NJavaFX.getTranslation("file_download_dialog.title"));
        this.targetFile = targetFile;
        this.serverFilePath = serverFilePath;
        this.setSize(300, 150);
        this.setResizable(false);
        this.initStyle(StageStyle.UTILITY);
    }

    @Override
    public void onOpen() {
        this.startDownload(this.serverFilePath, this.targetFile);
    }

    @Override
    protected void createButtons() {
        this.addButton(DialogButtonType.CANCEL, I18NJavaFX.getTranslation("cmd_cancel"), false, true);
    }

    @Override
    protected void onCancelPressed() {
        if (this.downloadTask != null) {
            this.downloadTask.cancel();
        }
    }

    @Override
    protected Node createDialogArea() {
        VBox panRoot = new VBox(10.0);
        this.progressBar = new ProgressBar(0.0);
        panRoot.getChildren().add((Object)this.progressBar);
        this.lblMessage = new Label();
        panRoot.getChildren().add((Object)this.lblMessage);
        this.progressBar.setPrefWidth(this.getWidth() - 20.0);
        this.lblMessage.setPrefWidth(this.getWidth() - 20.0);
        return panRoot;
    }

    public void onPercentCompleted(double percentage, long numberOfBytes, long totalNumberOfBytes) {
        Platform.runLater(() -> {
            this.progressBar.setProgress(percentage / 100.0);
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(ByteConverter.convert((long)numberOfBytes));
            params.add((int)percentage);
            this.lblMessage.setText(I18NJavaFX.getTranslation("file_download_dialog.bytes_processed", params.toArray()));
        });
    }

    public void startDownload(final String serverFilePath, final File targetFile) {
        DataProcessedEventController.addListener((DataProcessedListener)this);
        this.downloadTask = new Task<Void>(){

            protected Void call() throws Exception {
                ServiceLocator.downloadFile((String)targetFile.getAbsolutePath(), (String)serverFilePath);
                return null;
            }

            protected void done() {
                DataProcessedEventController.removeListener((DataProcessedListener)FileDownloadDialog.this);
                Platform.runLater(() -> ((FileDownloadDialog)FileDownloadDialog.this).close());
            }

            protected void succeeded() {
                FileDownloadDialog.this.returnCode = DialogButtonType.OK;
            }

            protected void failed() {
                FileDownloadDialog.this.exception = FileDownloadDialog.this.downloadTask.getException();
            }
        };
        new Thread((Runnable)this.downloadTask).start();
    }

    public Throwable getException() {
        return this.exception;
    }
}

