/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.richclient.javafx.dialog;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.Modality;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import net.sourceforge.jbizmo.commons.richclient.format.FormatDTO;
import net.sourceforge.jbizmo.commons.richclient.format.FormatPreferencesManager;
import net.sourceforge.jbizmo.commons.richclient.javafx.dialog.AbstractBaseDialog;
import net.sourceforge.jbizmo.commons.richclient.javafx.dialog.DialogUtil;
import net.sourceforge.jbizmo.commons.richclient.javafx.i18n.I18NJavaFX;

public class FormatPreferencesDialog
extends AbstractBaseDialog {
    private final FormatDTO userFormat = FormatPreferencesManager.getFormatDTO();
    private TextField txtDateFormat;
    private TextField txtDateTimeFormat;
    private TextField txtDecimalFormat;

    public FormatPreferencesDialog(Window owner) {
        super(owner, I18NJavaFX.getTranslation("format_preferences_dialog.title"));
        this.setSize(350, 200);
        this.initModality(Modality.APPLICATION_MODAL);
        this.initStyle(StageStyle.UTILITY);
    }

    @Override
    protected Node createDialogArea() {
        GridPane panContent = new GridPane();
        panContent.getColumnConstraints().add((Object)new ColumnConstraints(-1.0, -1.0, -1.0, Priority.NEVER, HPos.LEFT, false));
        panContent.getColumnConstraints().add((Object)new ColumnConstraints(-1.0, -1.0, -1.0, Priority.ALWAYS, HPos.LEFT, true));
        panContent.setHgap(5.0);
        panContent.setVgap(5.0);
        panContent.add((Node)new Label(I18NJavaFX.getTranslationForFieldLabel("format_preferences_dialog.lbl_date_format")), 0, 0);
        this.txtDateFormat = new TextField(this.userFormat.getDateFormat());
        panContent.add((Node)this.txtDateFormat, 1, 0);
        panContent.add((Node)new Label(I18NJavaFX.getTranslationForFieldLabel("format_preferences_dialog.lbl_date_time_format")), 0, 1);
        this.txtDateTimeFormat = new TextField(this.userFormat.getDateTimeFormat());
        panContent.add((Node)this.txtDateTimeFormat, 1, 1);
        panContent.add((Node)new Label(I18NJavaFX.getTranslationForFieldLabel("format_preferences_dialog.lbl_number_format")), 0, 2);
        this.txtDecimalFormat = new TextField(this.userFormat.getDecimalFormat());
        panContent.add((Node)this.txtDecimalFormat, 1, 2);
        return panContent;
    }

    @Override
    protected void onOKPressed() {
        String title = I18NJavaFX.getTranslation("format_preferences_dialog.title");
        SimpleDateFormat dateFormat = new SimpleDateFormat();
        DecimalFormat decimalFormat = new DecimalFormat();
        if (this.txtDateFormat.getText().isEmpty()) {
            DialogUtil.openInformationDialog((Window)this, title, I18NJavaFX.getTranslation("format_preferences_dialog.msg_invalid_date"));
            this.txtDateFormat.requestFocus();
            return;
        }
        try {
            dateFormat.applyPattern(this.txtDateFormat.getText());
        }
        catch (Exception e) {
            DialogUtil.openInformationDialog((Window)this, title, I18NJavaFX.getTranslation("format_preferences_dialog.msg_invalid_date"));
            this.txtDateFormat.requestFocus();
            return;
        }
        if (this.txtDateTimeFormat.getText().isEmpty()) {
            DialogUtil.openInformationDialog((Window)this, title, I18NJavaFX.getTranslation("format_preferences_dialog.msg_invalid_date_time"));
            this.txtDateTimeFormat.requestFocus();
            return;
        }
        try {
            dateFormat.applyPattern(this.txtDateTimeFormat.getText());
        }
        catch (Exception e) {
            DialogUtil.openInformationDialog((Window)this, title, I18NJavaFX.getTranslation("format_preferences_dialog.msg_invalid_date_time"));
            this.txtDateTimeFormat.requestFocus();
            return;
        }
        if (this.txtDecimalFormat.getText().isEmpty()) {
            DialogUtil.openInformationDialog((Window)this, title, I18NJavaFX.getTranslation("format_preferences_dialog.msg_invalid_number"));
            this.txtDecimalFormat.requestFocus();
            return;
        }
        try {
            decimalFormat.applyPattern(this.txtDecimalFormat.getText());
            decimalFormat.format(1.0);
        }
        catch (Exception e) {
            DialogUtil.openInformationDialog((Window)this, title, I18NJavaFX.getTranslation("format_preferences_dialog.msg_invalid_number"));
            this.txtDecimalFormat.requestFocus();
            return;
        }
        FormatDTO dtoFormat = new FormatDTO(this.txtDateFormat.getText(), this.txtDateTimeFormat.getText(), this.txtDecimalFormat.getText(), ",");
        FormatPreferencesManager.saveFormat((FormatDTO)dtoFormat);
        this.close();
    }
}

