/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.richclient.javafx.dialog;

import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.Modality;
import javafx.stage.Window;
import net.sourceforge.jbizmo.commons.richclient.javafx.dialog.AbstractBaseDialog;
import net.sourceforge.jbizmo.commons.richclient.javafx.dialog.DialogButtonType;
import net.sourceforge.jbizmo.commons.richclient.javafx.dialog.DialogUtil;
import net.sourceforge.jbizmo.commons.richclient.javafx.i18n.I18NJavaFX;

public class InputDialog
extends AbstractBaseDialog {
    private TextField txtInput;
    private String inputValue;
    private final String defaultValue;

    public InputDialog(Window owner, String title, String defaultValue) {
        super(owner, title);
        this.defaultValue = defaultValue;
        this.setSize(300, 150);
        this.initModality(Modality.APPLICATION_MODAL);
    }

    @Override
    protected Node createDialogArea() {
        GridPane panContent = new GridPane();
        panContent.getColumnConstraints().add((Object)new ColumnConstraints(50.0, -1.0, -1.0, Priority.SOMETIMES, HPos.LEFT, false));
        panContent.getColumnConstraints().add((Object)new ColumnConstraints(-1.0, -1.0, -1.0, Priority.ALWAYS, HPos.LEFT, true));
        panContent.add((Node)new Label(I18NJavaFX.getTranslationForFieldLabel("input_dialog.lbl_input")), 0, 0);
        panContent.setHgap(5.0);
        panContent.setVgap(5.0);
        this.txtInput = new TextField();
        if (this.defaultValue != null) {
            this.txtInput.setText(this.defaultValue);
        }
        panContent.add((Node)this.txtInput, 1, 0);
        return panContent;
    }

    @Override
    protected void onOKPressed() {
        this.returnCode = DialogButtonType.CANCEL;
        if (this.txtInput.getText().isEmpty()) {
            String message = I18NJavaFX.getTranslation("input_dialog.msg_input_required");
            String title = I18NJavaFX.getTranslation("input_dialog.msg_input_required_title");
            DialogUtil.openWarningDialog((Window)this, title, message);
            this.txtInput.requestFocus();
            return;
        }
        this.inputValue = this.txtInput.getText();
        this.returnCode = DialogButtonType.OK;
        this.close();
    }

    public String getInputValue() {
        return this.inputValue;
    }
}

