/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.richclient.javafx.dialog;

import java.io.PrintWriter;
import java.io.StringWriter;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.image.ImageView;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.Modality;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import net.sourceforge.jbizmo.commons.richclient.javafx.dialog.AbstractBaseDialog;
import net.sourceforge.jbizmo.commons.richclient.javafx.dialog.DialogButtonType;
import net.sourceforge.jbizmo.commons.richclient.javafx.dialog.MessageDialogType;
import net.sourceforge.jbizmo.commons.richclient.javafx.i18n.I18NJavaFX;
import net.sourceforge.jbizmo.commons.richclient.javafx.image.ImageLoader;

public class MessageDialog
extends AbstractBaseDialog {
    private final String message;
    private final MessageDialogType type;
    private Throwable error;

    public MessageDialog(Window owner, MessageDialogType dialogType, String title, String message) {
        super(owner, title);
        this.message = message;
        this.type = dialogType;
        this.setSize(400, 150);
        this.initModality(Modality.APPLICATION_MODAL);
        this.initStyle(StageStyle.UTILITY);
    }

    public MessageDialog(Window owner, MessageDialogType dialogType, String title, String message, Throwable error) {
        this(owner, dialogType, title, message);
        this.error = error;
        if (error != null) {
            this.setSize(550, 500);
        }
    }

    public MessageDialog(Window owner, MessageDialogType dialogType, String title, Throwable error) {
        this(owner, dialogType, title, null, error);
    }

    @Override
    protected Node createDialogArea() {
        GridPane panContent = new GridPane();
        panContent.getColumnConstraints().add((Object)new ColumnConstraints(-1.0, -1.0, -1.0, Priority.ALWAYS, HPos.LEFT, true));
        panContent.getColumnConstraints().add((Object)new ColumnConstraints(-1.0, -1.0, -1.0, Priority.NEVER, HPos.RIGHT, false));
        panContent.setHgap(5.0);
        panContent.setVgap(5.0);
        Label lblMsg = new Label();
        if (this.message != null) {
            lblMsg.setText(this.message);
        }
        if (this.message == null && this.error != null) {
            lblMsg.setText(this.error.getMessage());
        }
        lblMsg.setWrapText(true);
        ImageView imageView = new ImageView();
        if (this.type == MessageDialogType.INFORMATION) {
            imageView.setImage(ImageLoader.getImage("dialog_information.png"));
        } else if (this.type == MessageDialogType.WARNING) {
            imageView.setImage(ImageLoader.getImage("dialog_warning.png"));
        } else if (this.type == MessageDialogType.CONFIRMATION) {
            imageView.setImage(ImageLoader.getImage("dialog_confirm.png"));
        } else if (this.type == MessageDialogType.ERROR) {
            imageView.setImage(ImageLoader.getImage("dialog_error.png"));
        }
        panContent.add((Node)lblMsg, 0, 0);
        panContent.add((Node)imageView, 1, 0);
        if (this.error != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.error.printStackTrace(pw);
            Label lblDetails = new Label(I18NJavaFX.getTranslationForFieldLabel("message_dialog.lbl_details"));
            TextArea txtDetails = new TextArea(sw.toString());
            txtDetails.setEditable(false);
            txtDetails.setWrapText(false);
            panContent.add((Node)lblDetails, 0, 1, 2, 1);
            panContent.add((Node)txtDetails, 0, 2, 2, 1);
            GridPane.setVgrow((Node)txtDetails, (Priority)Priority.ALWAYS);
        }
        return panContent;
    }

    @Override
    protected void buttonPressed(DialogButtonType type) {
        super.buttonPressed(type);
        this.close();
    }

    @Override
    protected void createButtons() {
        if (this.type == MessageDialogType.CONFIRMATION) {
            this.addButton(DialogButtonType.YES, I18NJavaFX.getTranslation("cmd_yes"), true, false);
            this.addButton(DialogButtonType.NO, I18NJavaFX.getTranslation("cmd_no"), false, true);
        } else {
            this.addButton(DialogButtonType.OK, I18NJavaFX.getTranslation("cmd_ok"), true, false);
        }
    }
}

