/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.richclient.javafx.dialog;

import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.VBox;
import javafx.stage.Window;
import net.sourceforge.jbizmo.commons.richclient.javafx.dialog.AbstractBaseDialog;
import net.sourceforge.jbizmo.commons.richclient.javafx.image.ImageLoader;

public abstract class TitleAreaDialog
extends AbstractBaseDialog {
    private Label lblMessage;
    private ImageView imgMessage;
    private String titleMessage;
    private Image titleImage;
    private String infoMessage;
    private String errorMessage;

    public TitleAreaDialog(Window owner, String title, String titleMessage, Image titleImage) {
        super(owner, title);
        this.titleMessage = titleMessage;
        this.titleImage = titleImage;
    }

    public TitleAreaDialog(Window owner, String title) {
        super(owner, title);
    }

    protected void setTitleImage(Image titleImage) {
        this.titleImage = titleImage;
    }

    protected void setTitleMessage(String titleMessage) {
        this.titleMessage = titleMessage;
    }

    private Node createTitleArea() {
        GridPane panTitle = new GridPane();
        panTitle.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        panTitle.setPrefSize(-1.0, 55.0);
        panTitle.getColumnConstraints().add((Object)new ColumnConstraints(10.0, -1.0, -1.0, Priority.ALWAYS, HPos.LEFT, false));
        panTitle.getColumnConstraints().add((Object)new ColumnConstraints(60.0, -1.0, -1.0, Priority.SOMETIMES, HPos.LEFT, false));
        panTitle.setStyle("-fx-background-color: white;");
        ImageView imgViewTitle = new ImageView();
        imgViewTitle.setImage(this.titleImage);
        panTitle.add((Node)imgViewTitle, 1, 0);
        GridPane.setHalignment((Node)imgViewTitle, (HPos)HPos.RIGHT);
        GridPane.setHgrow((Node)imgViewTitle, (Priority)Priority.NEVER);
        GridPane.setVgrow((Node)imgViewTitle, (Priority)Priority.NEVER);
        GridPane panLabels = new GridPane();
        panLabels.getColumnConstraints().add((Object)new ColumnConstraints(18.0, 18.0, 18.0, Priority.SOMETIMES, HPos.LEFT, false));
        panLabels.getColumnConstraints().add((Object)new ColumnConstraints(-1.0, -1.0, -1.0, Priority.ALWAYS, HPos.LEFT, true));
        panLabels.getRowConstraints().add((Object)new RowConstraints(20.0, 20.0, 20.0, Priority.ALWAYS, VPos.TOP, false));
        panLabels.getRowConstraints().add((Object)new RowConstraints(30.0, 30.0, 30.0, Priority.SOMETIMES, VPos.CENTER, false));
        this.lblMessage = new Label();
        Label lblTitle = new Label(this.titleMessage);
        lblTitle.getStyleClass().add((Object)"title_message");
        this.imgMessage = new ImageView();
        panLabels.add((Node)lblTitle, 0, 0, 2, 1);
        panLabels.add((Node)this.lblMessage, 1, 1);
        panLabels.add((Node)this.imgMessage, 0, 1);
        GridPane.setHgrow((Node)lblTitle, (Priority)Priority.ALWAYS);
        GridPane.setValignment((Node)lblTitle, (VPos)VPos.TOP);
        GridPane.setHgrow((Node)this.lblMessage, (Priority)Priority.ALWAYS);
        GridPane.setValignment((Node)this.lblMessage, (VPos)VPos.TOP);
        GridPane.setHgrow((Node)this.imgMessage, (Priority)Priority.ALWAYS);
        GridPane.setValignment((Node)this.imgMessage, (VPos)VPos.TOP);
        panTitle.add((Node)panLabels, 0, 0);
        GridPane.setHgrow((Node)panLabels, (Priority)Priority.ALWAYS);
        GridPane.setVgrow((Node)panLabels, (Priority)Priority.ALWAYS);
        GridPane.setFillWidth((Node)panLabels, (Boolean)true);
        return panTitle;
    }

    @Override
    protected Parent createContents() {
        VBox panRoot = new VBox();
        VBox panParent = new VBox();
        panParent.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        Node content = this.createDialogArea();
        VBox.setVgrow((Node)panParent, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)panRoot, (Priority)Priority.ALWAYS);
        panParent.getChildren().add((Object)content);
        VBox.setVgrow((Node)content, (Priority)Priority.ALWAYS);
        panRoot.getChildren().add((Object)this.createTitleArea());
        panRoot.getChildren().add((Object)new Separator());
        panRoot.getChildren().add((Object)panParent);
        panRoot.getChildren().add((Object)new Separator());
        panRoot.getChildren().add((Object)this.createButtonBar());
        if (this.errorMessage != null) {
            this.setErrorMessage(this.errorMessage);
        } else if (this.infoMessage != null) {
            this.setInfoMessage(this.infoMessage);
        }
        return panRoot;
    }

    protected void setInfoMessage(String message) {
        if (this.lblMessage != null) {
            this.lblMessage.setText(message);
        } else {
            this.infoMessage = message;
        }
        if (this.imgMessage != null) {
            this.imgMessage.setImage(ImageLoader.getImage("information.png"));
        }
    }

    protected void setErrorMessage(String message) {
        if (this.lblMessage != null) {
            this.lblMessage.setText(message);
            this.lblMessage.setTooltip(new Tooltip(message));
        } else {
            this.errorMessage = message;
        }
        if (this.imgMessage != null) {
            this.imgMessage.setImage(ImageLoader.getImage("error.png"));
        }
    }
}

