/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.richclient.javafx.search;

import java.awt.Desktop;
import java.io.File;
import java.text.DecimalFormat;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.geometry.Insets;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.control.ToolBar;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import net.sourceforge.jbizmo.commons.richclient.format.FormatDTO;
import net.sourceforge.jbizmo.commons.richclient.format.FormatPreferencesManager;
import net.sourceforge.jbizmo.commons.richclient.javafx.control.Action;
import net.sourceforge.jbizmo.commons.richclient.javafx.control.StatusBar;
import net.sourceforge.jbizmo.commons.richclient.javafx.dialog.DialogUtil;
import net.sourceforge.jbizmo.commons.richclient.javafx.i18n.I18NJavaFX;
import net.sourceforge.jbizmo.commons.richclient.javafx.image.ImageLoader;
import net.sourceforge.jbizmo.commons.richclient.javafx.util.XLSXExportUtility;
import org.slf4j.Logger;

public abstract class AbstractDataGridPanel<T>
extends VBox {
    private static final String DEFAULT_EXPORT_FILE_NAME = "Export.xlsx";
    private final Window owner;
    protected ToolBar toolBar;
    protected TableView<T> tableView;
    protected Action refreshAction;
    protected Action exportAction;
    protected Action suspendAction;
    protected Action copyCellAction;
    protected ContextMenu mnuTableView;
    protected StatusBar statusBar;
    protected FormatDTO userFormat = FormatPreferencesManager.getFormatDTO();
    protected DateTimeFormatter dateTimeFormat = DateTimeFormatter.ofPattern(this.userFormat.getDateTimeFormat()).withZone(ZoneId.systemDefault());
    protected DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern(this.userFormat.getDateFormat()).withZone(ZoneId.systemDefault());
    protected DecimalFormat decimalFormat = new DecimalFormat(this.userFormat.getDecimalFormat());
    private DataFetchTask refreshViewTask;

    public AbstractDataGridPanel(Window owner) {
        this.owner = owner;
    }

    public Window getOwner() {
        return this.owner;
    }

    protected abstract String getCellText(T var1, int var2);

    protected abstract ObservableList<TableColumn<T, String>> initColumns();

    protected abstract List<T> fetchData() throws Exception;

    protected abstract Logger getLogger();

    protected void onStartSearch() {
        this.tableView.getItems().clear();
        this.statusBar.showProgress();
        this.statusBar.setText(I18NJavaFX.getTranslation("data_fetch_action.status_fetch_data"));
        this.suspendAction.setEnabled(true);
        this.refreshAction.setEnabled(false);
        this.exportAction.setEnabled(false);
    }

    protected void onFinishSearch(int itemsFetched, long countResult, long timeElapsed) {
        this.suspendAction.setEnabled(false);
        this.refreshAction.setEnabled(true);
        this.exportAction.setEnabled(true);
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(itemsFetched);
        params.add(String.format("%.2f", (double)timeElapsed / 1000.0));
        String statusMessage = I18NJavaFX.getTranslation("data_fetch_action.result_no_count", params.toArray());
        this.statusBar.stopProgress();
        this.statusBar.setText(statusMessage);
    }

    protected void onSearchFailed(Throwable cause) {
        this.statusBar.stopProgress();
        this.suspendAction.setEnabled(false);
        this.refreshAction.setEnabled(true);
        this.exportAction.setEnabled(true);
        if (cause == null) {
            this.statusBar.setText(I18NJavaFX.getTranslation("data_fetch_action.status_op_canceled"));
        } else {
            DialogUtil.openErrorDialog(this.owner, I18NJavaFX.getTranslation("data_fetch_action.msg_query_failed"), cause);
        }
    }

    protected long onPerformCountOperation() throws Exception {
        return 0L;
    }

    public void initialize() {
        this.getLogger().debug("Initialize grid panel");
        this.toolBar = new ToolBar();
        this.mnuTableView = new ContextMenu();
        this.statusBar = new StatusBar();
        this.tableView = new TableView();
        this.tableView.setContextMenu(this.mnuTableView);
        this.tableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.tableView.getSelectionModel().setCellSelectionEnabled(true);
        this.tableView.setPrefHeight(100.0);
        this.tableView.setMaxHeight(Double.MAX_VALUE);
        this.tableView.setMaxWidth(Double.MAX_VALUE);
        this.tableView.setOnMouseClicked(e -> {
            if (e.getClickCount() == 2) {
                this.onDoubleClick(this.tableView.getSelectionModel().getSelectedItem());
            }
        });
        this.tableView.setOnKeyPressed(e -> {
            if (e.getCode().equals((Object)KeyCode.ENTER)) {
                this.onEnterPressed(this.getSelectedItem());
            } else if (e.getCode().equals((Object)KeyCode.DELETE)) {
                this.onDeletePressed(this.getSelectedItem());
            }
        });
        this.getChildren().add((Object)this.toolBar);
        this.getChildren().add(this.tableView);
        this.getChildren().add((Object)this.statusBar);
        this.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        VBox.setVgrow(this.tableView, (Priority)Priority.ALWAYS);
        this.getLogger().debug("Grid panel initialization finished");
    }

    public T getSelectedItem() {
        return (T)this.tableView.getSelectionModel().getSelectedItem();
    }

    protected void addActionToContextMenu(Action action) {
        MenuItem item = action.createMenuItem();
        if (item == null) {
            return;
        }
        this.mnuTableView.getItems().add((Object)item);
    }

    protected void addActionToContextMenu(Action action, KeyCodeCombination keyCodeCombination) {
        MenuItem item = action.createMenuItem(keyCodeCombination);
        if (item == null) {
            return;
        }
        this.mnuTableView.getItems().add((Object)item);
    }

    protected void addActionToToolBar(Action action) {
        Button button = action.createToolbarButton();
        if (button == null) {
            return;
        }
        this.toolBar.getItems().add((Object)button);
    }

    public ToolBar getToolBar() {
        return this.toolBar;
    }

    public ContextMenu getContextMenu() {
        return this.mnuTableView;
    }

    public TableView<T> getTableView() {
        return this.tableView;
    }

    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    public void refreshView() {
        this.refreshViewTask = new DataFetchTask();
        new Thread((Runnable)((Object)this.refreshViewTask)).start();
    }

    public void initActions() {
        this.refreshAction = new RefreshAction();
        this.exportAction = new ExportAction();
        this.suspendAction = new SuspendSearchAction();
        this.copyCellAction = new CopyCellAction();
        this.getContextMenu().getItems().add((Object)this.refreshAction.createMenuItem());
        this.getContextMenu().getItems().add((Object)this.exportAction.createMenuItem());
        this.getContextMenu().getItems().add((Object)this.copyCellAction.createMenuItem());
        this.toolBar.getItems().add((Object)this.refreshAction.createToolbarButton());
        this.toolBar.getItems().add((Object)this.exportAction.createToolbarButton());
        this.toolBar.getItems().add((Object)this.suspendAction.createToolbarButton());
        this.suspendAction.setEnabled(false);
    }

    protected void onDoubleClick(T item) {
    }

    protected void onEnterPressed(T item) {
    }

    protected void onDeletePressed(T item) {
    }

    private class DataFetchTask
    extends Task<Void> {
        private DataFetchTask() {
        }

        protected void cancelled() {
            AbstractDataGridPanel.this.onSearchFailed(null);
        }

        public Void call() throws Exception {
            long start = System.currentTimeMillis();
            AbstractDataGridPanel.this.getLogger().debug("Perform data fetch operation");
            Platform.runLater(AbstractDataGridPanel.this::onStartSearch);
            List data = AbstractDataGridPanel.this.fetchData();
            if (this.isDone()) {
                return null;
            }
            long countResult = AbstractDataGridPanel.this.onPerformCountOperation();
            if (this.isDone()) {
                return null;
            }
            Platform.runLater(() -> {
                if (data != null) {
                    AbstractDataGridPanel.this.tableView.setItems(FXCollections.observableArrayList((Collection)data));
                    AbstractDataGridPanel.this.onFinishSearch(data.size(), countResult, System.currentTimeMillis() - start);
                } else {
                    AbstractDataGridPanel.this.onFinishSearch(0, countResult, System.currentTimeMillis() - start);
                }
                AbstractDataGridPanel.this.getLogger().debug("Data fetch operation finished");
            });
            return null;
        }

        protected void failed() {
            AbstractDataGridPanel.this.getLogger().error("Error while fetching data!", this.getException());
            AbstractDataGridPanel.this.onSearchFailed(this.getException());
        }
    }

    private class ExportAction
    extends Action {
        public ExportAction() {
            this.title = I18NJavaFX.getTranslation("action_export.title");
            this.image = ImageLoader.getImage("export_excel.png");
        }

        @Override
        public void handle() {
            XLSXExportUtility xlsxExporter = new XLSXExportUtility(AbstractDataGridPanel.this.tableView);
            if (!Desktop.isDesktopSupported()) {
                FileChooser fc = new FileChooser();
                fc.setTitle(I18NJavaFX.getTranslation("action_export.dialog_title"));
                fc.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(I18NJavaFX.getTranslation("action_export.xlsx_filter_desc"), new String[]{"*.xlsx"}));
                fc.setInitialFileName(AbstractDataGridPanel.DEFAULT_EXPORT_FILE_NAME);
                File file = fc.showSaveDialog(AbstractDataGridPanel.this.getParent().getScene().getWindow());
                if (file == null) {
                    return;
                }
                try {
                    xlsxExporter.exportToFile(file);
                }
                catch (Exception e) {
                    AbstractDataGridPanel.this.getLogger().error("Error while exporting table data!", (Throwable)e);
                    DialogUtil.openErrorDialog(AbstractDataGridPanel.this.owner, I18NJavaFX.getTranslation("action_export.msg_export_error"), e);
                }
            } else {
                File file;
                try {
                    file = xlsxExporter.exportToTempFile();
                }
                catch (Exception e) {
                    AbstractDataGridPanel.this.getLogger().error("Error while exporting table data!", (Throwable)e);
                    DialogUtil.openErrorDialog(AbstractDataGridPanel.this.owner, I18NJavaFX.getTranslation("action_export.msg_export_error"), e);
                    return;
                }
                Task<Void> exportTask = new Task<Void>(){

                    protected Void call() throws Exception {
                        Desktop.getDesktop().open(file);
                        return null;
                    }
                };
                new Thread((Runnable)exportTask).start();
            }
        }
    }

    protected class CopyCellAction
    extends Action {
        public CopyCellAction() {
            this.title = I18NJavaFX.getTranslation("action_copy.title");
            this.image = ImageLoader.getImage("copy.png");
        }

        @Override
        public void handle() {
            StringBuilder clipboardString = new StringBuilder();
            int previousRow = -1;
            for (TablePosition pos : AbstractDataGridPanel.this.tableView.getSelectionModel().getSelectedCells()) {
                int currentRow = pos.getRow();
                int currentCol = pos.getColumn();
                Object cell = ((TableColumn)AbstractDataGridPanel.this.tableView.getColumns().get(currentCol)).getCellData(currentRow);
                if (cell == null) {
                    cell = "";
                }
                if (previousRow == currentRow) {
                    clipboardString.append('\t');
                } else if (previousRow != -1) {
                    clipboardString.append('\n');
                }
                clipboardString.append(cell);
                previousRow = currentRow;
            }
            ClipboardContent content = new ClipboardContent();
            content.putString(clipboardString.toString());
            Clipboard.getSystemClipboard().setContent((Map)content);
        }
    }

    protected class SuspendSearchAction
    extends Action {
        public SuspendSearchAction() {
            this.title = I18NJavaFX.getTranslation("action_suspend.title");
            this.image = ImageLoader.getImage("stop.png");
        }

        @Override
        public void handle() {
            if (AbstractDataGridPanel.this.refreshViewTask != null && AbstractDataGridPanel.this.refreshViewTask.isRunning()) {
                AbstractDataGridPanel.this.refreshViewTask.cancel();
            }
        }
    }

    private class RefreshAction
    extends Action {
        public RefreshAction() {
            this.title = I18NJavaFX.getTranslation("action_refresh.title");
            this.image = ImageLoader.getImage("refresh.png");
        }

        @Override
        public void handle() {
            AbstractDataGridPanel.this.refreshView();
        }
    }
}

