/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.richclient.javafx.search;

import java.text.DecimalFormat;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.ToolBar;
import javafx.scene.input.KeyCodeCombination;
import net.sourceforge.jbizmo.commons.richclient.format.FormatDTO;
import net.sourceforge.jbizmo.commons.richclient.format.FormatPreferencesManager;
import net.sourceforge.jbizmo.commons.richclient.javafx.control.Action;
import net.sourceforge.jbizmo.commons.richclient.javafx.control.StatusBar;
import net.sourceforge.jbizmo.commons.richclient.javafx.control.View;
import net.sourceforge.jbizmo.commons.richclient.javafx.search.AbstractDataGridPanel;
import net.sourceforge.jbizmo.commons.search.dto.SearchDTO;
import net.sourceforge.jbizmo.commons.search.dto.SearchFieldDTO;
import org.slf4j.Logger;

public abstract class AbstractDataGridView<T>
extends Tab
implements View {
    protected SearchDTO searchObj = new SearchDTO();
    protected FormatDTO userFormat = FormatPreferencesManager.getFormatDTO();
    protected DateTimeFormatter dateTimeFormat = DateTimeFormatter.ofPattern(this.userFormat.getDateTimeFormat()).withZone(ZoneId.systemDefault());
    protected DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern(this.userFormat.getDateFormat()).withZone(ZoneId.systemDefault());
    protected DecimalFormat decimalFormat = new DecimalFormat(this.userFormat.getDecimalFormat());
    private AbstractDataGridPanel<T> gridPanel;
    protected String title;
    protected Integer savedQueryId;
    protected boolean performInitialLoad = true;

    public AbstractDataGridView(String title) {
        this(title, null, null);
    }

    public AbstractDataGridView(String title, SearchDTO searchObj, Integer savedQueryId) {
        this.title = title;
        this.searchObj = searchObj;
        this.savedQueryId = savedQueryId;
    }

    @Override
    public Integer getSavedQueryId() {
        return this.savedQueryId;
    }

    public String getViewID() {
        return this.getClass().getName();
    }

    protected abstract String getCellText(T var1, int var2);

    protected abstract Logger getLogger();

    protected ObservableList<TableColumn<T, String>> initColumns() {
        ObservableList columnList = FXCollections.observableArrayList();
        List<SearchFieldDTO> fieldList = this.searchObj.getSearchFields().stream().sorted((a, b) -> Integer.compare(a.getColOrder(), b.getColOrder())).collect(Collectors.toList());
        fieldList.forEach(searchField -> {
            TableColumn col = new TableColumn(searchField.getColLabel());
            col.setPrefWidth((double)searchField.getColWidth());
            col.setUserData((Object)searchField.getDataType());
            col.setVisible(searchField.isVisible());
            col.setCellValueFactory(param -> new SimpleStringProperty(this.getCellText(param.getValue(), searchField.getOriginalColumnIndex())));
            columnList.add((Object)col);
        });
        return columnList;
    }

    protected abstract SearchDTO initSearchObject();

    protected abstract List<T> fetchData() throws Exception;

    protected void onDoubleClick(T item) {
    }

    protected void onEnterPressed(T item) {
    }

    protected void onDeletePressed(T item) {
    }

    protected void onStartSearch() {
    }

    protected void onFinishSearch(int itemsFetched, long countResult, long timeElapsed) {
    }

    protected void onSearchFailed(Throwable cause) {
    }

    protected long onPerformCountOperation() throws Exception {
        return 0L;
    }

    public T getSelectedItem() {
        return this.gridPanel.getSelectedItem();
    }

    protected ToolBar getToolBar() {
        return this.gridPanel.getToolBar();
    }

    protected TableView<T> getTableView() {
        return this.gridPanel.getTableView();
    }

    protected StatusBar getStatusBar() {
        return this.gridPanel.getStatusBar();
    }

    protected void addActionToContextMenu(Action action) {
        this.gridPanel.addActionToContextMenu(action);
    }

    protected void addActionToContextMenu(Action action, KeyCodeCombination keyCodeCombination) {
        this.gridPanel.addActionToContextMenu(action, keyCodeCombination);
    }

    protected void addActionToToolBar(Action action) {
        this.gridPanel.addActionToToolBar(action);
    }

    protected void refreshView() {
        this.gridPanel.refreshView();
    }

    protected void initActions() {
        this.gridPanel.initActions();
    }

    private void changeColumnOrder() {
        int colIndex = 0;
        block0: for (TableColumn col : this.getTableView().getColumns()) {
            for (SearchFieldDTO searchField : this.searchObj.getSearchFields()) {
                if (!col.getText().equals(searchField.getColLabel())) continue;
                searchField.setColOrder(colIndex++);
                continue block0;
            }
        }
    }

    @Override
    public void initialize() {
        this.getLogger().debug("Initialize view");
        this.gridPanel = new AbstractDataGridPanel<T>(null){

            @Override
            protected String getCellText(T element, int colIndex) {
                return AbstractDataGridView.this.getCellText(element, colIndex);
            }

            @Override
            protected ObservableList<TableColumn<T, String>> initColumns() {
                return AbstractDataGridView.this.initColumns();
            }

            @Override
            protected List<T> fetchData() throws Exception {
                return AbstractDataGridView.this.fetchData();
            }

            @Override
            protected void onStartSearch() {
                super.onStartSearch();
                AbstractDataGridView.this.onStartSearch();
            }

            @Override
            protected void onFinishSearch(int itemsFetched, long countResult, long timeElapsed) {
                super.onFinishSearch(itemsFetched, countResult, timeElapsed);
                AbstractDataGridView.this.onFinishSearch(itemsFetched, countResult, timeElapsed);
            }

            @Override
            protected long onPerformCountOperation() throws Exception {
                return AbstractDataGridView.this.onPerformCountOperation();
            }

            @Override
            protected void onSearchFailed(Throwable cause) {
                super.onSearchFailed(cause);
                AbstractDataGridView.this.onSearchFailed(cause);
            }

            @Override
            protected void onDoubleClick(T item) {
                AbstractDataGridView.this.onDoubleClick(item);
            }

            @Override
            protected void onDeletePressed(T item) {
                AbstractDataGridView.this.onDeletePressed(item);
            }

            @Override
            protected void onEnterPressed(T item) {
                AbstractDataGridView.this.onEnterPressed(item);
            }

            @Override
            protected Logger getLogger() {
                return AbstractDataGridView.this.getLogger();
            }
        };
        this.setContent((Node)this.gridPanel);
        if (this.searchObj == null) {
            this.searchObj = this.initSearchObject();
        }
        this.gridPanel.initialize();
        this.gridPanel.getTableView().getColumns().addAll(this.initColumns());
        this.initActions();
        if (this.performInitialLoad) {
            this.refreshView();
        }
        this.getTableView().getColumns().addListener(change -> this.changeColumnOrder());
        this.getLogger().debug("View initialization finished");
    }

    @Override
    public Tab getTab() {
        return this;
    }

    public String toString() {
        return this.title;
    }
}

