/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.richclient.javafx.search;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import javafx.scene.control.TableColumn;
import net.sourceforge.jbizmo.commons.richclient.format.FormatPreferencesManager;
import net.sourceforge.jbizmo.commons.richclient.javafx.control.Action;
import net.sourceforge.jbizmo.commons.richclient.javafx.dialog.DialogButtonType;
import net.sourceforge.jbizmo.commons.richclient.javafx.dialog.DialogUtil;
import net.sourceforge.jbizmo.commons.richclient.javafx.dialog.InputDialog;
import net.sourceforge.jbizmo.commons.richclient.javafx.i18n.I18NJavaFX;
import net.sourceforge.jbizmo.commons.richclient.javafx.image.ImageLoader;
import net.sourceforge.jbizmo.commons.richclient.javafx.search.AbstractDataGridView;
import net.sourceforge.jbizmo.commons.richclient.javafx.search.Countable;
import net.sourceforge.jbizmo.commons.richclient.javafx.search.SearchInputDialog;
import net.sourceforge.jbizmo.commons.richclient.search.util.DuplicateSearchNameException;
import net.sourceforge.jbizmo.commons.richclient.search.util.SearchManager;
import net.sourceforge.jbizmo.commons.search.dto.SearchDTO;
import net.sourceforge.jbizmo.commons.search.dto.SearchFieldDTO;

public abstract class AbstractSearchGridView<T>
extends AbstractDataGridView<T>
implements Countable {
    public static final int DEFAULT_MAX_FETCH_SIZE = 1000;
    protected SearchInputAction actionSearch;
    protected FetchPreviousPageAction actionPrev;
    protected FetchNextPageAction actionNext;
    protected SaveQueryAction actionSaveQuery;
    protected boolean enableNext;
    protected boolean enablePrevious;
    protected int pageIndex = 1;

    public AbstractSearchGridView(String title) {
        this(title, null, null);
    }

    public AbstractSearchGridView(String title, SearchDTO searchObj, Integer savedQueryId) {
        super(title, searchObj, savedQueryId);
    }

    @Override
    protected void initActions() {
        super.initActions();
        this.actionSearch = new SearchInputAction();
        this.actionNext = new FetchNextPageAction();
        this.actionPrev = new FetchPreviousPageAction();
        this.actionSaveQuery = new SaveQueryAction();
        this.getToolBar().getItems().add((Object)this.actionSearch.createToolbarButton());
        this.getToolBar().getItems().add((Object)this.actionPrev.createToolbarButton());
        this.getToolBar().getItems().add((Object)this.actionNext.createToolbarButton());
        this.getToolBar().getItems().add((Object)this.actionSaveQuery.createToolbarButton());
        this.actionNext.setEnabled(false);
        this.actionPrev.setEnabled(false);
    }

    private void saveSearch() {
        if (this.savedQueryId != null) {
            return;
        }
        block0: for (SearchFieldDTO searchField : this.searchObj.getSearchFields()) {
            for (TableColumn col : this.getTableView().getColumns()) {
                if (!col.getText().equals(searchField.getColLabel())) continue;
                searchField.setColWidth((int)col.getWidth());
                continue block0;
            }
        }
        SearchManager.saveLastSearch((String)this.getViewID(), (SearchDTO)this.searchObj);
    }

    @Override
    public void initialize() {
        this.performInitialLoad = false;
        if (this.savedQueryId == null) {
            this.searchObj = SearchManager.getLastSearch((String)this.getViewID());
            if (this.searchObj != null) {
                this.performInitialLoad = true;
            }
        } else {
            this.performInitialLoad = true;
        }
        super.initialize();
        this.setOnClosed(e -> this.saveSearch());
    }

    @Override
    protected long onPerformCountOperation() {
        if (!this.searchObj.isCount()) {
            return 0L;
        }
        this.getLogger().debug("Perform count operation");
        try {
            return this.countData();
        }
        catch (Exception e) {
            this.getLogger().error("Error while performing count operation!", (Throwable)e);
            return 0L;
        }
    }

    @Override
    protected void onStartSearch() {
        super.onStartSearch();
        this.actionNext.setEnabled(false);
        this.actionPrev.setEnabled(false);
        this.actionSearch.setEnabled(false);
        this.refreshFormatSettings();
    }

    @Override
    protected void onSearchFailed(Throwable cause) {
        super.onSearchFailed(cause);
        this.actionNext.setEnabled(false);
        this.actionPrev.setEnabled(false);
        this.actionSearch.setEnabled(true);
    }

    @Override
    protected void onFinishSearch(int itemsFetched, long countResult, long timeElapsed) {
        String statusMessage = "";
        if (this.searchObj.isCount() && countResult > 0L) {
            int pageLength = this.searchObj.getMaxResult();
            long pageCount = ((long)pageLength + countResult - 1L) / (long)pageLength;
            this.enableNext = (long)this.pageIndex < pageCount;
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(itemsFetched);
            params.add(countResult);
            params.add(String.format("%.2f", (double)timeElapsed / 1000.0));
            params.add(pageCount > 0L ? this.pageIndex : 0);
            params.add(pageCount);
            statusMessage = I18NJavaFX.getTranslation("data_fetch_action.result_with_count", params.toArray());
        } else {
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(itemsFetched);
            params.add(String.format("%.2f", (double)timeElapsed / 1000.0));
            statusMessage = I18NJavaFX.getTranslation("data_fetch_action.result_no_count", params.toArray());
            this.enableNext = false;
        }
        if (this.savedQueryId == null) {
            SearchManager.saveLastSearch((String)this.getViewID(), (SearchDTO)this.searchObj);
        }
        this.actionNext.setEnabled(this.enableNext);
        this.actionPrev.setEnabled(this.enablePrevious);
        this.actionSearch.setEnabled(true);
        this.getStatusBar().setText(statusMessage);
    }

    public void refreshFormatSettings() {
        this.userFormat = FormatPreferencesManager.getFormatDTO();
        this.decimalFormat = new DecimalFormat(this.userFormat.getDecimalFormat());
        this.dateTimeFormat = DateTimeFormatter.ofPattern(this.userFormat.getDateTimeFormat()).withZone(ZoneId.systemDefault());
        this.dateFormat = DateTimeFormatter.ofPattern(this.userFormat.getDateFormat()).withZone(ZoneId.systemDefault());
        this.searchObj.setDecimalSeparator(DecimalFormatSymbols.getInstance().getDecimalSeparator());
        this.searchObj.setGroupingSeparator(DecimalFormatSymbols.getInstance().getGroupingSeparator());
        this.searchObj.setDateFormat(this.userFormat.getDateFormat());
        this.searchObj.setDateTimeFormat(this.userFormat.getDateTimeFormat());
        this.searchObj.setNumberFormat(this.userFormat.getDecimalFormat());
    }

    protected class FetchPreviousPageAction
    extends Action {
        public FetchPreviousPageAction() {
            this.title = I18NJavaFX.getTranslation("action_fetch_prev.title");
            this.image = ImageLoader.getImage("view_previous.png");
        }

        @Override
        public void handle() {
            if (!AbstractSearchGridView.this.enablePrevious) {
                return;
            }
            int startIndex = AbstractSearchGridView.this.searchObj.getStartIndex();
            int maxResult = AbstractSearchGridView.this.searchObj.getMaxResult();
            AbstractSearchGridView.this.searchObj.setStartIndex(startIndex - maxResult);
            if (AbstractSearchGridView.this.pageIndex == 2) {
                AbstractSearchGridView.this.enablePrevious = false;
            }
            AbstractSearchGridView.this.enableNext = true;
            this.setEnabled(AbstractSearchGridView.this.enablePrevious);
            AbstractSearchGridView.this.actionNext.setEnabled(AbstractSearchGridView.this.enableNext);
            --AbstractSearchGridView.this.pageIndex;
            AbstractSearchGridView.this.refreshView();
        }
    }

    protected class FetchNextPageAction
    extends Action {
        public FetchNextPageAction() {
            this.title = I18NJavaFX.getTranslation("action_fetch_next.title");
            this.image = ImageLoader.getImage("view_next.png");
        }

        @Override
        public void handle() {
            if (!AbstractSearchGridView.this.enableNext) {
                return;
            }
            int startIndex = AbstractSearchGridView.this.searchObj.getStartIndex();
            int maxResult = AbstractSearchGridView.this.searchObj.getMaxResult();
            AbstractSearchGridView.this.searchObj.setStartIndex(startIndex + maxResult);
            AbstractSearchGridView.this.enablePrevious = true;
            AbstractSearchGridView.this.actionPrev.setEnabled(AbstractSearchGridView.this.enablePrevious);
            ++AbstractSearchGridView.this.pageIndex;
            AbstractSearchGridView.this.refreshView();
        }
    }

    public class SaveQueryAction
    extends Action {
        public SaveQueryAction() {
            this.title = I18NJavaFX.getTranslation("action_save_query.title");
            this.image = ImageLoader.getImage("saved_search.png");
        }

        @Override
        public void handle() {
            String queryName = "";
            String dialogTitle = I18NJavaFX.getTranslation("action_save_query.msg_save_query_title");
            if (AbstractSearchGridView.this.savedQueryId != null) {
                String message = I18NJavaFX.getTranslation("action_save_query.msg_overwrite_query");
                if (DialogButtonType.YES != DialogUtil.openConfirmationDialog(null, dialogTitle, message)) {
                    return;
                }
            } else {
                String defaultValue;
                String title = I18NJavaFX.getTranslation("action_save_query.input_dialog_new_query_title");
                InputDialog dlg = new InputDialog(null, title, defaultValue = I18NJavaFX.getTranslation("action_save_query.input_dialog_new_query_default_value"));
                if (DialogButtonType.OK != dlg.open()) {
                    return;
                }
                queryName = dlg.getInputValue();
            }
            try {
                if (AbstractSearchGridView.this.savedQueryId == null) {
                    SearchManager.saveSearch((String)AbstractSearchGridView.this.getViewID(), (SearchDTO)AbstractSearchGridView.this.searchObj, (String)queryName);
                } else {
                    SearchManager.overwriteSavedSearchObject((int)AbstractSearchGridView.this.savedQueryId, (SearchDTO)AbstractSearchGridView.this.searchObj);
                }
                AbstractSearchGridView.this.getStatusBar().setText(I18NJavaFX.getTranslation("action_save_query.msg_query_saved"));
            }
            catch (DuplicateSearchNameException ex) {
                String message = I18NJavaFX.getTranslation("action_save_query.msg_query_duplicate", queryName);
                DialogUtil.openWarningDialog(null, dialogTitle, message);
            }
            catch (Exception ex) {
                AbstractSearchGridView.this.getLogger().error("Error while saving query!", (Throwable)ex);
                String titleMsg = I18NJavaFX.getTranslation("action_save_query.msg_query_save_error");
                DialogUtil.openErrorDialog(null, this.title, titleMsg, ex);
            }
        }
    }

    private class SearchInputAction
    extends Action {
        public SearchInputAction() {
            this.title = I18NJavaFX.getTranslation("action_search.title");
            this.image = ImageLoader.getImage("search.png");
        }

        @Override
        public void handle() {
            AbstractSearchGridView.this.refreshFormatSettings();
            SearchInputDialog dlg = new SearchInputDialog(null, AbstractSearchGridView.this.searchObj, AbstractSearchGridView.this);
            dlg.setSize(700, 600);
            if (DialogButtonType.OK != dlg.open()) {
                return;
            }
            block0: for (TableColumn col : AbstractSearchGridView.this.getTableView().getColumns()) {
                for (SearchFieldDTO field : AbstractSearchGridView.this.searchObj.getSearchFields()) {
                    if (!col.getText().equals(field.getColLabel())) continue;
                    col.setVisible(field.isVisible());
                    continue block0;
                }
            }
            AbstractSearchGridView.this.searchObj.setStartIndex(0);
            AbstractSearchGridView.this.pageIndex = 1;
            AbstractSearchGridView.this.enableNext = false;
            AbstractSearchGridView.this.enablePrevious = false;
            AbstractSearchGridView.this.actionNext.setEnabled(AbstractSearchGridView.this.enableNext);
            AbstractSearchGridView.this.actionPrev.setEnabled(AbstractSearchGridView.this.enablePrevious);
            AbstractSearchGridView.this.refreshView();
        }
    }
}

