/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.richclient.javafx.search;

import java.lang.invoke.MethodHandles;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.VBox;
import javafx.stage.Window;
import javafx.util.StringConverter;
import net.sourceforge.jbizmo.commons.richclient.format.FormatDTO;
import net.sourceforge.jbizmo.commons.richclient.format.FormatPreferencesManager;
import net.sourceforge.jbizmo.commons.richclient.javafx.control.AbstractProposalTextField;
import net.sourceforge.jbizmo.commons.richclient.javafx.control.AbstractSelectionListPanel;
import net.sourceforge.jbizmo.commons.richclient.javafx.control.LocalDateConverter;
import net.sourceforge.jbizmo.commons.richclient.javafx.dialog.DialogButtonType;
import net.sourceforge.jbizmo.commons.richclient.javafx.dialog.DialogUtil;
import net.sourceforge.jbizmo.commons.richclient.javafx.dialog.TitleAreaDialog;
import net.sourceforge.jbizmo.commons.richclient.javafx.i18n.I18NJavaFX;
import net.sourceforge.jbizmo.commons.richclient.javafx.image.ImageLoader;
import net.sourceforge.jbizmo.commons.richclient.javafx.search.Countable;
import net.sourceforge.jbizmo.commons.richclient.transport.ServiceLocator;
import net.sourceforge.jbizmo.commons.search.SearchService;
import net.sourceforge.jbizmo.commons.search.dto.SearchDTO;
import net.sourceforge.jbizmo.commons.search.dto.SearchFieldDTO;
import net.sourceforge.jbizmo.commons.search.dto.SearchFieldDataTypeEnum;
import net.sourceforge.jbizmo.commons.search.dto.SearchFieldTypeEnum;
import net.sourceforge.jbizmo.commons.search.dto.SearchOperatorDTO;
import net.sourceforge.jbizmo.commons.search.dto.SortDirectionEnum;
import net.sourceforge.jbizmo.commons.search.util.SearchOperatorHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchInputDialog
extends TitleAreaDialog {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private GridPane panFilter;
    private CheckBox chkExactFilterMatch;
    private CheckBox chkCountRecords;
    private ComboBox<Integer> cboFetchSize;
    private CheckBox chkCaseSensitive;
    private AbstractSelectionListPanel<SearchFieldDTO> listColumns;
    private final SearchDTO searchObj;
    private final HashMap<String, ComboBox<String>> operatorMap = new HashMap();
    private final HashMap<String, ComboBox<SortDirectionEnum>> sortMap = new HashMap();
    private final HashMap<String, Control> filterMap1 = new HashMap();
    private final HashMap<String, Control> filterMap2 = new HashMap();
    private final FormatDTO userFormat = FormatPreferencesManager.getFormatDTO();
    private final Countable countable;
    private final DecimalFormat decimalFormat = new DecimalFormat(this.userFormat.getDecimalFormat());
    private final SimpleDateFormat dateTimeFormat = new SimpleDateFormat(this.userFormat.getDateTimeFormat());
    private final SimpleDateFormat dateFormat = new SimpleDateFormat(this.userFormat.getDateFormat());

    public SearchInputDialog(Window owner, SearchDTO searchObj, Countable countable) {
        super(owner, I18NJavaFX.getTranslation("search_input_dialog.title"));
        this.searchObj = searchObj;
        this.countable = countable;
    }

    @Override
    protected Node createDialogArea() {
        this.setTitleImage(ImageLoader.getImage("window_search_title.png"));
        this.setTitleMessage(I18NJavaFX.getTranslation("search_input_dialog.title_msg"));
        TabPane tabPane = new TabPane();
        Tab tabFilter = new Tab(I18NJavaFX.getTranslation("search_input_dialog.tab_filter"));
        tabPane.getTabs().add((Object)tabFilter);
        this.panFilter = new GridPane();
        this.panFilter.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        this.panFilter.getColumnConstraints().add((Object)new ColumnConstraints(-1.0, 130.0, -1.0, Priority.SOMETIMES, HPos.LEFT, false));
        this.panFilter.getColumnConstraints().add((Object)new ColumnConstraints(-1.0, -1.0, -1.0, Priority.SOMETIMES, HPos.LEFT, false));
        this.panFilter.getColumnConstraints().add((Object)new ColumnConstraints(-1.0, 80.0, -1.0, Priority.SOMETIMES, HPos.LEFT, false));
        this.panFilter.getColumnConstraints().add((Object)new ColumnConstraints(-1.0, -1.0, -1.0, Priority.ALWAYS, HPos.LEFT, true));
        this.panFilter.getColumnConstraints().add((Object)new ColumnConstraints(-1.0, -1.0, -1.0, Priority.ALWAYS, HPos.LEFT, true));
        this.panFilter.setHgap(5.0);
        this.panFilter.setVgap(5.0);
        Label lblFieldName = new Label(I18NJavaFX.getTranslation("search_input_dialog.lbl_field_name"));
        lblFieldName.getStyleClass().add((Object)"field_column_title");
        this.panFilter.add((Node)lblFieldName, 0, 0);
        Label lblOperator = new Label(I18NJavaFX.getTranslation("search_input_dialog.lbl_operator"));
        lblOperator.getStyleClass().add((Object)"field_column_title");
        this.panFilter.add((Node)lblOperator, 1, 0);
        Label lblSortOrder = new Label(I18NJavaFX.getTranslation("search_input_dialog.lbl_sort_order"));
        lblSortOrder.getStyleClass().add((Object)"field_column_title");
        this.panFilter.add((Node)lblSortOrder, 2, 0);
        Label lblFilter = new Label(I18NJavaFX.getTranslation("search_input_dialog.lbl_filter"));
        lblFilter.getStyleClass().add((Object)"field_column_title");
        this.panFilter.add((Node)lblFilter, 3, 0);
        tabFilter.setContent((Node)this.panFilter);
        Tab tabAdvSettings = new Tab(I18NJavaFX.getTranslation("search_input_dialog.tab_adv_settings"));
        tabPane.getTabs().add((Object)tabAdvSettings);
        VBox panAdvSettings = new VBox(10.0);
        panAdvSettings.setPadding(new Insets(10.0, 0.0, 0.0, 0.0));
        tabAdvSettings.setContent((Node)panAdvSettings);
        GridPane panAdvFields = new GridPane();
        panAdvFields.setHgap(10.0);
        panAdvFields.add((Node)new Label(I18NJavaFX.getTranslationForFieldLabel("search_input_dialog.max_fetch_size")), 0, 0);
        this.cboFetchSize = new ComboBox();
        this.cboFetchSize.getItems().add((Object)10);
        this.cboFetchSize.getItems().add((Object)100);
        this.cboFetchSize.getItems().add((Object)1000);
        this.cboFetchSize.getItems().add((Object)10000);
        this.cboFetchSize.getItems().add((Object)100000);
        this.cboFetchSize.setValue((Object)this.searchObj.getMaxResult());
        this.chkExactFilterMatch = new CheckBox(I18NJavaFX.getTranslation("search_input_dialog.cbo_exact_filter_match"));
        this.chkExactFilterMatch.setSelected(this.searchObj.isExactFilterMatch());
        this.chkCountRecords = new CheckBox(I18NJavaFX.getTranslation("search_input_dialog.chk_count_records"));
        this.chkCountRecords.setSelected(this.searchObj.isCount());
        this.chkCaseSensitive = new CheckBox(I18NJavaFX.getTranslation("search_input_dialog.chk_case_sensitive"));
        this.chkCaseSensitive.setSelected(this.searchObj.isCaseSensitive());
        panAdvFields.add(this.cboFetchSize, 1, 0);
        panAdvFields.add((Node)this.chkExactFilterMatch, 2, 0);
        panAdvFields.add((Node)this.chkCountRecords, 3, 0);
        panAdvFields.add((Node)this.chkCaseSensitive, 4, 0);
        this.listColumns = new AbstractSelectionListPanel<SearchFieldDTO>(I18NJavaFX.getTranslation("search_input_dialog.list_columns_title"), false){

            @Override
            public String getItemText(SearchFieldDTO element) {
                return element.getColLabel();
            }

            @Override
            public List<SearchFieldDTO> searchItems(String filter) throws Exception {
                return null;
            }
        };
        panAdvSettings.getChildren().add((Object)panAdvFields);
        panAdvSettings.getChildren().add(this.listColumns);
        VBox.setVgrow(this.listColumns, (Priority)Priority.ALWAYS);
        this.initFilterFields();
        return tabPane;
    }

    private String[] splitFilterInput(SearchFieldDTO searchField) {
        String[] values;
        if (searchField.getOperator() == null) {
            String[] values2 = new String[]{searchField.getFilterCriteria()};
            return values2;
        }
        if (!searchField.getOperator().isExpectsArgument()) {
            return new String[0];
        }
        if (searchField.getOperator().getValue().equals("between")) {
            if (searchField.getFilterCriteria().split("  ").length != 2) {
                return new String[0];
            }
            values = searchField.getFilterCriteria().split("  ");
        } else {
            values = new String[]{searchField.getFilterCriteria()};
        }
        return values;
    }

    private void initBooleanField(SearchFieldDTO searchField, int rowIndex) {
        ComboBox cboCrit1 = new ComboBox();
        cboCrit1.getItems().add((Object)Boolean.TRUE.toString().toLowerCase());
        cboCrit1.getItems().add((Object)Boolean.FALSE.toString().toLowerCase());
        cboCrit1.getItems().add((Object)"");
        if (searchField.getFilterCriteria() != null) {
            cboCrit1.setValue((Object)searchField.getFilterCriteria());
        }
        this.panFilter.add((Node)cboCrit1, 3, rowIndex);
        this.filterMap1.put(searchField.getColLabel(), (Control)cboCrit1);
    }

    private void initEnumField(SearchFieldDTO searchField, int rowIndex) {
        ComboBox cboCrit1 = new ComboBox();
        cboCrit1.setItems(FXCollections.observableArrayList(searchField.getEnumListValues().values()));
        if (searchField.getFilterCriteria() != null) {
            cboCrit1.setValue((Object)searchField.getFilterCriteria());
        }
        this.panFilter.add((Node)cboCrit1, 3, rowIndex);
        this.filterMap1.put(searchField.getColLabel(), (Control)cboCrit1);
    }

    private void initDateField(SearchFieldDTO searchField, int rowIndex) {
        DatePicker datePicker = new DatePicker();
        datePicker.setConverter((StringConverter)new LocalDateConverter());
        this.panFilter.add((Node)datePicker, 3, rowIndex);
        this.filterMap1.put(searchField.getColLabel(), (Control)datePicker);
        DatePicker datePicker2 = new DatePicker();
        datePicker2.setVisible(false);
        datePicker2.setConverter((StringConverter)new LocalDateConverter());
        this.panFilter.add((Node)datePicker2, 4, rowIndex);
        this.filterMap2.put(searchField.getColLabel(), (Control)datePicker2);
        if (searchField.getOperator() != null && searchField.getOperator().getValue().equals("between")) {
            datePicker2.setVisible(true);
        }
        int colIndex = 1;
        for (String criterion : this.splitFilterInput(searchField)) {
            if (criterion == null || criterion.isEmpty()) continue;
            Date dateValue = new Date();
            try {
                dateValue = searchField.isDateTimeFormat() ? this.dateTimeFormat.parse(criterion) : this.dateFormat.parse(criterion);
            }
            catch (ParseException e) {
                logger.error("Could not parse criterion '{}'!", (Object)criterion, (Object)e);
            }
            DatePicker dp = (DatePicker)this.filterMap1.get(searchField.getColLabel());
            if (colIndex == 2) {
                dp = (DatePicker)this.filterMap2.get(searchField.getColLabel());
            }
            dp.setValue((Object)dateValue.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
            ++colIndex;
        }
    }

    private void initTextField(final SearchFieldDTO searchField, int rowIndex) {
        TextField txtCrit1;
        if (searchField.getDataType() != SearchFieldDataTypeEnum.STRING && searchField.getDataType() != SearchFieldDataTypeEnum.CHAR) {
            txtCrit1 = new TextField();
            this.filterMap1.put(searchField.getColLabel(), (Control)txtCrit1);
            this.panFilter.add((Node)txtCrit1, 3, rowIndex);
            TextField txtCrit2 = new TextField();
            txtCrit2.setVisible(false);
            this.panFilter.add((Node)txtCrit2, 4, rowIndex);
            this.filterMap2.put(searchField.getColLabel(), (Control)txtCrit2);
            if (searchField.getOperator() != null && searchField.getOperator().getValue().equals("between")) {
                txtCrit2.setVisible(true);
            }
            int colIndex = 1;
            for (String criterion : this.splitFilterInput(searchField)) {
                if (criterion == null || criterion.isEmpty()) continue;
                TextField txtInput = (TextField)this.filterMap1.get(searchField.getColLabel());
                if (colIndex == 2) {
                    txtInput = (TextField)this.filterMap2.get(searchField.getColLabel());
                }
                txtInput.setText(criterion);
                ++colIndex;
            }
        } else {
            txtCrit1 = new TextField();
            txtCrit1.setText(searchField.getFilterCriteria());
            this.filterMap1.put(searchField.getColLabel(), (Control)txtCrit1);
            this.panFilter.add((Node)txtCrit1, 3, rowIndex, 2, 1);
        }
        if (searchField.getLovCommand() != null) {
            txtCrit1 = new AbstractProposalTextField<String>(){

                @Override
                public String getProposalText(String item) {
                    return item;
                }

                @Override
                public List<String> getProposalItems(String textEntered) {
                    SearchService searchService = (SearchService)ServiceLocator.getService(SearchService.class);
                    try {
                        return searchService.getListOfValues(searchField.getLovCommand(), textEntered).stream().collect(Collectors.toList());
                    }
                    catch (Exception e) {
                        logger.error("Error while searching for proposal items by using input text '{}'!", (Object)textEntered, (Object)e);
                        return Collections.emptyList();
                    }
                }
            };
            this.filterMap1.put(searchField.getColLabel(), (Control)txtCrit1);
            this.panFilter.add((Node)txtCrit1, 3, rowIndex, 2, 1);
            txtCrit1.setSelectedItem(searchField.getFilterCriteria());
        }
    }

    private void initFilterFields() {
        int rowIndex = 1;
        ArrayList<SearchFieldDTO> visibleFields = new ArrayList<SearchFieldDTO>();
        ArrayList<SearchFieldDTO> hiddenFields = new ArrayList<SearchFieldDTO>();
        for (SearchFieldDTO searchField : this.searchObj.getSearchFields()) {
            String key = searchField.getColLabel();
            if (searchField.getType() == SearchFieldTypeEnum.NOT_SEARCHABLE) continue;
            if (searchField.isVisible()) {
                visibleFields.add(searchField);
            } else {
                hiddenFields.add(searchField);
            }
            this.panFilter.getRowConstraints().add((Object)new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.CENTER, false));
            Label lblField = new Label(searchField.getColLabel());
            this.panFilter.add((Node)lblField, 0, rowIndex);
            ComboBox cboOp = new ComboBox();
            cboOp.setItems(SearchOperatorHelper.getOperatorsForField((SearchFieldDTO)searchField).stream().map(SearchOperatorDTO::getDescription).collect(Collectors.toCollection(FXCollections::observableArrayList)));
            cboOp.getItems().add((Object)"");
            cboOp.setValue((Object)"");
            if (searchField.getOperator() != null) {
                cboOp.setValue((Object)searchField.getOperator().getDescription());
            }
            this.panFilter.add((Node)cboOp, 1, rowIndex);
            ComboBox cboSort = new ComboBox();
            cboSort.setItems(FXCollections.observableArrayList((Object[])SortDirectionEnum.values()));
            cboSort.setValue((Object)searchField.getSortOrder());
            this.panFilter.add((Node)cboSort, 2, rowIndex);
            this.operatorMap.put(key, (ComboBox<String>)cboOp);
            this.sortMap.put(key, (ComboBox<SortDirectionEnum>)cboSort);
            if (searchField.getDataType() == SearchFieldDataTypeEnum.BOOLEAN) {
                this.initBooleanField(searchField, rowIndex);
            } else if (searchField.getDataType() == SearchFieldDataTypeEnum.ENUM) {
                this.initEnumField(searchField, rowIndex);
            } else if (searchField.hasTemporalDataType()) {
                this.initDateField(searchField, rowIndex);
            } else {
                this.initTextField(searchField, rowIndex);
            }
            if (searchField.getOperator() != null && !searchField.getOperator().isExpectsArgument()) {
                Control c1 = this.filterMap1.get(searchField.getColLabel());
                c1.setDisable(true);
                Control c2 = this.filterMap2.get(searchField.getColLabel());
                if (c2 != null) {
                    c2.setVisible(false);
                }
            }
            cboOp.valueProperty().addListener((ov, oldValue, newValue) -> {
                this.filterMap1.get(key).setDisable(false);
                if (this.filterMap2.get(key) != null) {
                    this.filterMap2.get(key).setVisible(false);
                }
                if (newValue.equals("is null") || newValue.equals("is not null")) {
                    this.filterMap1.get(key).setDisable(true);
                } else if (newValue.equals("between") && this.filterMap2.get(key) != null) {
                    this.filterMap2.get(key).setVisible(true);
                }
                this.resetFieldInput(key);
            });
            ++rowIndex;
        }
        this.listColumns.setSelectedItems(visibleFields);
        this.listColumns.setAvailableItems(hiddenFields);
    }

    private void resetFieldInput(String key) {
        Control c = this.filterMap1.get(key);
        if (c instanceof TextField) {
            TextField textField = (TextField)c;
            textField.setText("");
        } else if (c instanceof DatePicker) {
            DatePicker datePicker = (DatePicker)c;
            datePicker.setValue(null);
        } else {
            ComboBox comboBox = (ComboBox)c;
            comboBox.setValue((Object)"");
        }
        Control c2 = this.filterMap2.get(key);
        if (c2 == null) {
            return;
        }
        if (c2 instanceof TextField) {
            TextField textField = (TextField)c2;
            textField.setText("");
        } else if (c2 instanceof DatePicker) {
            DatePicker datePicker = (DatePicker)c2;
            datePicker.setValue(null);
        }
    }

    private void reset() {
        ArrayList<SearchFieldDTO> selectedFields = new ArrayList<SearchFieldDTO>();
        for (SearchFieldDTO searchField : this.searchObj.getSearchFields()) {
            if (searchField.getType() == SearchFieldTypeEnum.NOT_SEARCHABLE) continue;
            searchField.setFilterCriteria("");
            searchField.setOperator(null);
            searchField.setVisible(true);
            searchField.setSortOrder(SortDirectionEnum.NONE);
        }
        this.searchObj.setExactFilterMatch(true);
        this.searchObj.setCaseSensitive(false);
        this.searchObj.setCount(true);
        this.searchObj.setMaxResult(1000);
        for (SearchFieldDTO searchField : this.searchObj.getSearchFields()) {
            if (searchField.getType() == SearchFieldTypeEnum.NOT_SEARCHABLE) continue;
            this.operatorMap.get(searchField.getColLabel()).setValue((Object)"");
            this.sortMap.get(searchField.getColLabel()).setValue((Object)searchField.getSortOrder());
            selectedFields.add(searchField);
            this.resetFieldInput(searchField.getColLabel());
        }
        this.listColumns.setAvailableItems(new ArrayList());
        this.listColumns.setSelectedItems(selectedFields);
        this.chkCaseSensitive.setSelected(this.searchObj.isCaseSensitive());
        this.chkCountRecords.setSelected(this.searchObj.isCount());
        this.chkExactFilterMatch.setSelected(this.searchObj.isExactFilterMatch());
        this.cboFetchSize.setValue((Object)this.searchObj.getMaxResult());
    }

    private void applyInput(SearchFieldDTO searchField) {
        ComboBox cbo;
        if (searchField.getType() == SearchFieldTypeEnum.NOT_SEARCHABLE) {
            return;
        }
        String key = searchField.getColLabel();
        if (this.listColumns.getSelectedItems().contains(searchField)) {
            searchField.setVisible(true);
        } else {
            searchField.setVisible(false);
        }
        String op = (String)this.operatorMap.get(key).getValue();
        searchField.setSortOrder((SortDirectionEnum)this.sortMap.get(key).getValue());
        if (op.isEmpty()) {
            searchField.setOperator(null);
        } else {
            for (Object sod : SearchOperatorHelper.getAllOperators()) {
                if (!op.equals(sod.getDescription())) continue;
                searchField.setOperator((SearchOperatorDTO)sod);
                break;
            }
        }
        if (searchField.getDataType() == SearchFieldDataTypeEnum.BOOLEAN) {
            cbo = (ComboBox)this.filterMap1.get(key);
            if (cbo.getValue() == null || ((String)cbo.getValue()).isEmpty()) {
                searchField.setFilterCriteria(null);
            } else {
                searchField.setFilterCriteria((String)cbo.getValue());
            }
        } else if (searchField.getDataType() == SearchFieldDataTypeEnum.ENUM) {
            cbo = (ComboBox)this.filterMap1.get(key);
            if (cbo.getValue() == null || ((String)cbo.getValue()).isEmpty()) {
                searchField.setFilterCriteria(null);
            } else {
                for (String enumLiteral : searchField.getEnumListValues().keySet()) {
                    if (!((String)searchField.getEnumListValues().get(enumLiteral)).equals(cbo.getValue())) continue;
                    searchField.setFilterCriteria(enumLiteral);
                }
            }
        } else if (searchField.hasTemporalDataType()) {
            DatePicker datePicker1 = (DatePicker)this.filterMap1.get(key);
            DatePicker datePicker2 = (DatePicker)this.filterMap2.get(key);
            if (datePicker1.getValue() != null) {
                Date date1 = Date.from(Instant.from(((LocalDate)datePicker1.getValue()).atStartOfDay(ZoneId.systemDefault())));
                Date date2 = datePicker2.isVisible() && datePicker2.getValue() != null ? Date.from(Instant.from(((LocalDate)datePicker2.getValue()).atStartOfDay(ZoneId.systemDefault()))) : null;
                if (date2 != null) {
                    if (searchField.isDateTimeFormat()) {
                        searchField.setFilterCriteria(this.dateTimeFormat.format(date1) + "  " + this.dateTimeFormat.format(date2));
                    } else {
                        searchField.setFilterCriteria(this.dateFormat.format(date1) + "  " + this.dateFormat.format(date2));
                    }
                } else if (searchField.isDateTimeFormat()) {
                    searchField.setFilterCriteria(this.dateTimeFormat.format(date1));
                } else {
                    searchField.setFilterCriteria(this.dateFormat.format(date1));
                }
            }
        } else {
            TextField txtInput1 = (TextField)this.filterMap1.get(key);
            TextField txtInput2 = (TextField)this.filterMap2.get(key);
            if (txtInput2 != null && txtInput2.isVisible()) {
                searchField.setFilterCriteria(txtInput1.getText() + "  " + txtInput2.getText());
            } else {
                searchField.setFilterCriteria(txtInput1.getText());
            }
        }
    }

    private boolean validateInput() {
        ArrayList<SearchFieldDTO> tempFieldList = new ArrayList<SearchFieldDTO>();
        for (SearchFieldDTO searchField : this.searchObj.getSearchFields()) {
            if (searchField.getType() == SearchFieldTypeEnum.NOT_SEARCHABLE) continue;
            SearchFieldDTO tempField = new SearchFieldDTO();
            tempField.setDataType(searchField.getDataType());
            tempField.setColLabel(searchField.getColLabel());
            tempField.setDateTimeFormat(searchField.isDateTimeFormat());
            tempField.setVisible(searchField.isVisible());
            tempField.setListOfValues(searchField.getListOfValues());
            tempField.setType(searchField.getType());
            tempField.setEnumListValues(searchField.getEnumListValues());
            this.applyInput(tempField);
            tempFieldList.add(tempField);
        }
        for (SearchFieldDTO searchField : tempFieldList) {
            if (searchField.getType() == SearchFieldTypeEnum.NOT_SEARCHABLE) continue;
            if (searchField.getOperator() != null) {
                StringTokenizer tokenizer;
                if (searchField.getOperator().isExpectsArgument() && (searchField.getFilterCriteria() == null || searchField.getFilterCriteria().isEmpty())) {
                    this.setErrorMessage(I18NJavaFX.getTranslation("search_input_dialog.msg_err_criterion_exp", searchField.getColLabel().toLowerCase()));
                    return false;
                }
                if ((searchField.getOperator().getValue().equals("in") || searchField.getOperator().getValue().equals("not in")) && (tokenizer = new StringTokenizer(searchField.getFilterCriteria(), ";;")).countTokens() < 2) {
                    this.setErrorMessage(I18NJavaFX.getTranslation("search_input_dialog.msg_err_missing_in"));
                    return false;
                }
                if (searchField.getOperator().getValue().equals("between") && searchField.getFilterCriteria().split("  ").length != 2) {
                    this.setErrorMessage(I18NJavaFX.getTranslation("search_input_dialog.msg_err_missing_between"));
                    return false;
                }
            }
            if (searchField.getDataType() != SearchFieldDataTypeEnum.LONG && searchField.getDataType() != SearchFieldDataTypeEnum.INTEGER && searchField.getDataType() != SearchFieldDataTypeEnum.FLOAT && searchField.getDataType() != SearchFieldDataTypeEnum.DOUBLE && searchField.getDataType() != SearchFieldDataTypeEnum.BIG_DECIMAL || searchField.getFilterCriteria() == null || searchField.getFilterCriteria().isEmpty()) continue;
            String[] values = this.splitFilterInput(searchField);
            if (searchField.getOperator() != null && (searchField.getOperator().getValue().equals("not in") || searchField.getOperator().getValue().equals("in"))) {
                values = searchField.getFilterCriteria().split(";;");
            }
            for (String value : values) {
                try {
                    if (searchField.getDataType() == SearchFieldDataTypeEnum.LONG || searchField.getDataType() == SearchFieldDataTypeEnum.INTEGER) {
                        Long.parseLong(value);
                        continue;
                    }
                    this.decimalFormat.parse(value);
                }
                catch (NumberFormatException | ParseException e) {
                    this.setErrorMessage(I18NJavaFX.getTranslation("search_input_dialog.msg_err_no_number", searchField.getColLabel().toLowerCase()));
                    return false;
                }
            }
        }
        return true;
    }

    private void applyInput() {
        this.searchObj.getSearchFields().forEach(this::applyInput);
        this.searchObj.setMaxResult(((Integer)this.cboFetchSize.getValue()).intValue());
        this.searchObj.setCaseSensitive(this.chkCaseSensitive.isSelected());
        this.searchObj.setCount(this.chkCountRecords.isSelected());
        this.searchObj.setExactFilterMatch(this.chkExactFilterMatch.isSelected());
    }

    @Override
    protected void onOKPressed() {
        this.returnCode = DialogButtonType.CANCEL;
        if (!this.validateInput()) {
            return;
        }
        this.returnCode = DialogButtonType.OK;
        this.applyInput();
        this.close();
    }

    @Override
    protected Node createButtonBar() {
        Node parent = super.createButtonBar();
        String title = I18NJavaFX.getTranslation("search_input_dialog.msg_count_res_title");
        Button cmdCount = this.addButton(DialogButtonType.COUNT, I18NJavaFX.getTranslation("cmd_count"));
        cmdCount.setOnAction(e -> {
            try {
                if (!this.validateInput()) {
                    return;
                }
                this.applyInput();
                long result = this.countable.countData();
                String message = I18NJavaFX.getTranslation("search_input_dialog.msg_count_res", result);
                DialogUtil.openInformationDialog((Window)this, title, message);
            }
            catch (Exception ex) {
                logger.error("Error while performing count operation!", (Throwable)ex);
                String message = I18NJavaFX.getTranslation("search_input_dialog.msg_count_error");
                DialogUtil.openErrorDialog((Window)this, title, message, ex);
            }
        });
        Button cmdReset = this.addButton(DialogButtonType.RESET, I18NJavaFX.getTranslation("cmd_reset"));
        cmdReset.setOnAction(e -> this.reset());
        return parent;
    }
}

