/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.richclient.javafx.tree;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.event.Event;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Tab;
import javafx.scene.control.ToolBar;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.DataFormat;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import net.sourceforge.jbizmo.commons.richclient.format.FormatDTO;
import net.sourceforge.jbizmo.commons.richclient.format.FormatPreferencesManager;
import net.sourceforge.jbizmo.commons.richclient.javafx.control.Action;
import net.sourceforge.jbizmo.commons.richclient.javafx.control.StatusBar;
import net.sourceforge.jbizmo.commons.richclient.javafx.control.View;
import net.sourceforge.jbizmo.commons.richclient.javafx.dialog.DialogButtonType;
import net.sourceforge.jbizmo.commons.richclient.javafx.dialog.DialogUtil;
import net.sourceforge.jbizmo.commons.richclient.javafx.i18n.I18NJavaFX;
import net.sourceforge.jbizmo.commons.richclient.javafx.image.ImageLoader;
import net.sourceforge.jbizmo.commons.richclient.javafx.search.Countable;
import net.sourceforge.jbizmo.commons.richclient.javafx.search.SearchInputDialog;
import net.sourceforge.jbizmo.commons.richclient.javafx.tree.TreeDataItem;
import net.sourceforge.jbizmo.commons.richclient.search.util.SearchManager;
import net.sourceforge.jbizmo.commons.search.dto.SearchDTO;
import net.sourceforge.jbizmo.commons.search.exception.GeneralSearchException;
import org.slf4j.Logger;

public abstract class AbstractTreeView<T>
extends Tab
implements View,
Countable {
    protected FormatDTO userFormat = FormatPreferencesManager.getFormatDTO();
    protected DateTimeFormatter dateTimeFormat = DateTimeFormatter.ofPattern(this.userFormat.getDateTimeFormat()).withZone(ZoneId.systemDefault());
    protected DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern(this.userFormat.getDateFormat()).withZone(ZoneId.systemDefault());
    protected DecimalFormat decimalFormat = new DecimalFormat(this.userFormat.getDecimalFormat());
    protected SearchDTO searchObj = new SearchDTO();
    protected ToolBar toolBar;
    protected TreeView<String> treeView;
    protected Action refreshAction;
    protected Action suspendAction;
    protected Action searchInputAction;
    protected StatusBar statusBar;
    protected TreeDataItem dragItem;
    private DataFetchTask refreshViewTask;

    protected abstract List<T> fetchRootItems() throws Exception;

    public abstract void addRootTreeItems(List<T> var1);

    protected abstract Logger getLogger();

    public ContextMenu getContextMenuForTreeItem(TreeDataItem item) {
        return null;
    }

    public SearchDTO initAdvancedSearch() {
        return null;
    }

    protected Node getQuickSearchBar() {
        return null;
    }

    public TransferMode startDrag(TreeDataItem item) {
        return null;
    }

    public void onDragDropped(DragEvent e, TreeDataItem item) {
    }

    public String getViewID() {
        return this.getClass().getName();
    }

    protected long onPerformCountOperation() throws Exception {
        if (this.initAdvancedSearch() == null || !this.searchObj.isCount()) {
            return 0L;
        }
        this.getLogger().debug("Perform count operation");
        try {
            return this.countData();
        }
        catch (Exception e) {
            this.getLogger().error("Error while performing count operation!", (Throwable)e);
            return 0L;
        }
    }

    protected void onStartSearch() {
        this.getLogger().debug("Search operation started");
        this.treeView.setRoot((TreeItem)new TreeDataItem(null, null));
        this.statusBar.showProgress();
        this.statusBar.setText(I18NJavaFX.getTranslation("data_fetch_action.status_fetch_data"));
        this.suspendAction.setEnabled(true);
        this.refreshAction.setEnabled(false);
        if (this.searchInputAction != null) {
            this.searchInputAction.setEnabled(false);
        }
    }

    protected void onFinishSearch(int itemsFetched, long countResult, long timeElapsed) {
        this.getLogger().debug("Search operation finished");
        String statusMessage = "";
        this.suspendAction.setEnabled(false);
        this.refreshAction.setEnabled(true);
        if (this.searchInputAction != null) {
            this.searchInputAction.setEnabled(true);
        }
        if (this.searchObj.isCount() && countResult > 0L) {
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(itemsFetched);
            params.add(countResult);
            params.add(String.format("%.2f", (double)timeElapsed / 1000.0));
            params.add(1);
            params.add(1);
            statusMessage = I18NJavaFX.getTranslation("data_fetch_action.result_with_count", params.toArray());
        } else {
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(itemsFetched);
            params.add(String.format("%.2f", (double)timeElapsed / 1000.0));
            statusMessage = I18NJavaFX.getTranslation("data_fetch_action.result_no_count", params.toArray());
        }
        this.statusBar.setText(statusMessage);
        this.statusBar.stopProgress();
    }

    protected void onSearchFailed(Throwable cause) {
        this.getLogger().error("Search operation failed!", cause);
        this.statusBar.stopProgress();
        this.suspendAction.setEnabled(false);
        this.refreshAction.setEnabled(true);
        if (this.searchInputAction != null) {
            this.searchInputAction.setEnabled(true);
        }
        if (cause == null) {
            this.statusBar.setText(I18NJavaFX.getTranslation("data_fetch_action.status_op_canceled"));
        } else {
            DialogUtil.openErrorDialog(null, I18NJavaFX.getTranslation("data_fetch_action.msg_query_failed"), cause);
        }
    }

    public void refreshView() {
        this.refreshViewTask = new DataFetchTask();
        new Thread((Runnable)((Object)this.refreshViewTask)).start();
    }

    @Override
    public void initialize() {
        this.getLogger().debug("Initialize tree view");
        VBox panRoot = new VBox();
        this.toolBar = new ToolBar();
        this.statusBar = new StatusBar();
        this.treeView = new TreeView();
        this.treeView.setShowRoot(false);
        this.treeView.setCellFactory(param -> new DragAndDropCell());
        panRoot.getChildren().add((Object)this.toolBar);
        Node quickSearchBar = this.getQuickSearchBar();
        if (quickSearchBar != null) {
            panRoot.getChildren().add((Object)quickSearchBar);
        }
        panRoot.getChildren().add(this.treeView);
        panRoot.getChildren().add((Object)this.statusBar);
        panRoot.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        VBox.setVgrow(this.treeView, (Priority)Priority.ALWAYS);
        this.initActions();
        this.setContent((Node)panRoot);
        this.getLogger().debug("Tree view initialization finished");
    }

    protected void initActions() {
        this.refreshAction = new RefreshAction();
        this.suspendAction = new SuspendSearchAction();
        this.toolBar.getItems().add((Object)this.refreshAction.createToolbarButton());
        this.toolBar.getItems().add((Object)this.suspendAction.createToolbarButton());
        this.suspendAction.setEnabled(false);
        if (this.initAdvancedSearch() != null) {
            this.searchInputAction = new SearchInputAction();
            this.toolBar.getItems().add((Object)this.searchInputAction.createToolbarButton());
        }
    }

    protected void refreshFormatSettings() {
        this.userFormat = FormatPreferencesManager.getFormatDTO();
        this.decimalFormat = new DecimalFormat(this.userFormat.getDecimalFormat());
        this.dateTimeFormat = DateTimeFormatter.ofPattern(this.userFormat.getDateTimeFormat()).withZone(ZoneId.systemDefault());
        this.dateFormat = DateTimeFormatter.ofPattern(this.userFormat.getDateFormat()).withZone(ZoneId.systemDefault());
        this.searchObj.setDecimalSeparator(DecimalFormatSymbols.getInstance().getDecimalSeparator());
        this.searchObj.setGroupingSeparator(DecimalFormatSymbols.getInstance().getGroupingSeparator());
        this.searchObj.setDateFormat(this.userFormat.getDateFormat());
        this.searchObj.setDateTimeFormat(this.userFormat.getDateTimeFormat());
        this.searchObj.setNumberFormat(this.userFormat.getDecimalFormat());
    }

    @Override
    public Tab getTab() {
        return this;
    }

    @Override
    public Integer getSavedQueryId() {
        return null;
    }

    @Override
    public long countData() throws GeneralSearchException {
        return 0L;
    }

    private class DataFetchTask
    extends Task<Void> {
        private DataFetchTask() {
        }

        protected void cancelled() {
            AbstractTreeView.this.onSearchFailed(null);
        }

        public Void call() throws Exception {
            long start = System.currentTimeMillis();
            Platform.runLater(AbstractTreeView.this::onStartSearch);
            List data = AbstractTreeView.this.fetchRootItems();
            if (this.isDone()) {
                return null;
            }
            long countResult = AbstractTreeView.this.onPerformCountOperation();
            if (this.isDone()) {
                return null;
            }
            Platform.runLater(() -> {
                if (data != null) {
                    AbstractTreeView.this.addRootTreeItems(data);
                    AbstractTreeView.this.onFinishSearch(data.size(), countResult, System.currentTimeMillis() - start);
                } else {
                    AbstractTreeView.this.onFinishSearch(0, countResult, System.currentTimeMillis() - start);
                }
            });
            return null;
        }

        protected void failed() {
            AbstractTreeView.this.onSearchFailed(this.getException());
        }
    }

    private class DragAndDropCell
    extends TreeCell<String> {
        public DragAndDropCell() {
            this.setOnDragDetected(e -> {
                if (!(this.getTreeItem() instanceof TreeDataItem)) {
                    return;
                }
                TransferMode mode = AbstractTreeView.this.startDrag((TreeDataItem)this.getTreeItem());
                if (mode == null) {
                    return;
                }
                AbstractTreeView.this.dragItem = (TreeDataItem)this.getTreeItem();
                HashMap<DataFormat, Object> content = new HashMap<DataFormat, Object>();
                content.put(DataFormat.PLAIN_TEXT, AbstractTreeView.this.dragItem.getValue() == null ? "" : AbstractTreeView.this.dragItem.getValue());
                Dragboard dragBoard = this.startDragAndDrop(new TransferMode[]{mode});
                dragBoard.setContent(content);
                e.consume();
            });
            this.setOnDragDone(Event::consume);
            this.setOnDragOver(e -> {
                e.acceptTransferModes(new TransferMode[]{TransferMode.COPY, TransferMode.MOVE});
                e.consume();
            });
            this.setOnDragDropped(e -> {
                if (this.getTreeItem() == null || AbstractTreeView.this.dragItem == null) {
                    return;
                }
                if (!(this.getTreeItem() instanceof TreeDataItem)) {
                    return;
                }
                AbstractTreeView.this.onDragDropped((DragEvent)e, (TreeDataItem)this.getTreeItem());
                AbstractTreeView.this.dragItem = null;
            });
        }

        protected void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
                this.setContextMenu(null);
                return;
            }
            if (this.getTreeItem() != null) {
                this.setText(item);
                this.setGraphic(this.getTreeItem().getGraphic());
                this.setContextMenu(AbstractTreeView.this.getContextMenuForTreeItem((TreeDataItem)this.getTreeItem()));
            }
        }
    }

    private class SearchInputAction
    extends Action {
        public SearchInputAction() {
            this.title = I18NJavaFX.getTranslation("action_search.title");
            this.image = ImageLoader.getImage("search.png");
        }

        @Override
        public void handle() {
            AbstractTreeView.this.refreshFormatSettings();
            AbstractTreeView.this.searchObj = AbstractTreeView.this.initAdvancedSearch();
            SearchInputDialog dlg = new SearchInputDialog(null, AbstractTreeView.this.searchObj, AbstractTreeView.this);
            dlg.setSize(700, 600);
            if (DialogButtonType.OK != dlg.open()) {
                return;
            }
            SearchManager.saveLastSearch((String)AbstractTreeView.this.getViewID(), (SearchDTO)AbstractTreeView.this.searchObj);
            AbstractTreeView.this.refreshView();
        }
    }

    protected class SuspendSearchAction
    extends Action {
        public SuspendSearchAction() {
            this.title = I18NJavaFX.getTranslation("action_suspend.title");
            this.image = ImageLoader.getImage("stop.png");
        }

        @Override
        public void handle() {
            if (AbstractTreeView.this.refreshViewTask != null && AbstractTreeView.this.refreshViewTask.isRunning()) {
                AbstractTreeView.this.refreshViewTask.cancel();
            }
        }
    }

    private class RefreshAction
    extends Action {
        public RefreshAction() {
            this.title = I18NJavaFX.getTranslation("action_refresh.title");
            this.image = ImageLoader.getImage("refresh.png");
        }

        @Override
        public void handle() {
            AbstractTreeView.this.searchObj = new SearchDTO();
            AbstractTreeView.this.searchObj.setMaxResult(1000);
            AbstractTreeView.this.searchObj.setExactFilterMatch(true);
            AbstractTreeView.this.searchObj.setCaseSensitive(false);
            AbstractTreeView.this.searchObj.setCount(true);
            AbstractTreeView.this.refreshView();
        }
    }
}

