/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.richclient.javafx.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import net.sourceforge.jbizmo.commons.richclient.format.FormatDTO;
import net.sourceforge.jbizmo.commons.richclient.format.FormatPreferencesManager;
import net.sourceforge.jbizmo.commons.search.dto.SearchFieldDataTypeEnum;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XLSXExportUtility {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String DEFAULT_SHEET_NAME = "Sheet 1";
    private static final String TEMP_FILE_PREFIX = "tmp";
    private static final String TEMP_FILE_SUFFIX = ".xlsx";
    private final HashSet<Integer> dateColumnIndexSet = new HashSet();
    private final TableView<?> tableView;
    protected FormatDTO userFormat = FormatPreferencesManager.getFormatDTO();
    protected SimpleDateFormat dateTimeFormat = new SimpleDateFormat(this.userFormat.getDateTimeFormat());
    protected SimpleDateFormat dateFormat = new SimpleDateFormat(this.userFormat.getDateFormat());
    protected DecimalFormat decimalFormat = new DecimalFormat(this.userFormat.getDecimalFormat());

    public XLSXExportUtility(TableView<?> tableView) {
        this.tableView = tableView;
    }

    private HashMap<String, Class<?>> initTypes() {
        HashMap typeMap = new HashMap();
        for (TableColumn col : this.tableView.getColumns()) {
            if (!col.isVisible()) continue;
            typeMap.put(col.getText(), String.class);
            SearchFieldDataTypeEnum type = (SearchFieldDataTypeEnum)col.getUserData();
            if (type == SearchFieldDataTypeEnum.BOOLEAN) {
                typeMap.put(col.getText(), Boolean.class);
                continue;
            }
            if (type == SearchFieldDataTypeEnum.CHAR) {
                typeMap.put(col.getText(), Character.class);
                continue;
            }
            if (type == SearchFieldDataTypeEnum.DOUBLE) {
                typeMap.put(col.getText(), Double.class);
                continue;
            }
            if (type == SearchFieldDataTypeEnum.BIG_DECIMAL) {
                typeMap.put(col.getText(), BigDecimal.class);
                continue;
            }
            if (type == SearchFieldDataTypeEnum.FLOAT) {
                typeMap.put(col.getText(), Double.class);
                continue;
            }
            if (type == SearchFieldDataTypeEnum.ENUM) {
                typeMap.put(col.getText(), Enum.class);
                continue;
            }
            if (type == SearchFieldDataTypeEnum.INTEGER) {
                typeMap.put(col.getText(), Long.class);
                continue;
            }
            if (type == SearchFieldDataTypeEnum.LONG) {
                typeMap.put(col.getText(), Long.class);
                continue;
            }
            if (type == SearchFieldDataTypeEnum.GREGORIAN_CALENDAR) {
                typeMap.put(col.getText(), Calendar.class);
                continue;
            }
            if (type == SearchFieldDataTypeEnum.DATE) {
                typeMap.put(col.getText(), Date.class);
                continue;
            }
            if (type == SearchFieldDataTypeEnum.LOCAL_DATE) {
                typeMap.put(col.getText(), LocalDate.class);
                continue;
            }
            if (type != SearchFieldDataTypeEnum.LOCAL_DATE_TIME) continue;
            typeMap.put(col.getText(), LocalDateTime.class);
        }
        return typeMap;
    }

    public File exportToTempFile() throws IOException, ParseException {
        File tempFile = null;
        tempFile = Files.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX, new FileAttribute[0]).toFile();
        tempFile.deleteOnExit();
        this.writeContentToXLSXFile(tempFile);
        return tempFile;
    }

    public void exportToFile(File file) throws IOException, ParseException {
        this.writeContentToXLSXFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeContentToXLSXFile(File file) throws IOException, ParseException {
        FileOutputStream fileOutputStream = null;
        SXSSFWorkbook workbook = null;
        Sheet sheet = null;
        Cell cell = null;
        Row row = null;
        try {
            workbook = new SXSSFWorkbook();
            sheet = workbook.createSheet(DEFAULT_SHEET_NAME);
            CreationHelper createHelper = workbook.getCreationHelper();
            CellStyle cellStyleDateTime = workbook.createCellStyle();
            cellStyleDateTime.setDataFormat(createHelper.createDataFormat().getFormat("dd.MM.yyyy HH:mm:ss"));
            CellStyle cellStyleDate = workbook.createCellStyle();
            cellStyleDate.setDataFormat(createHelper.createDataFormat().getFormat("dd.MM.yyyy"));
            CellStyle cellStyleDouble = workbook.createCellStyle();
            cellStyleDouble.setDataFormat(createHelper.createDataFormat().getFormat("###,###,##0.00"));
            Font headerFont = workbook.createFont();
            headerFont.setFontHeightInPoints((short)11);
            headerFont.setBoldweight((short)700);
            CellStyle headerCellStyle = workbook.createCellStyle();
            headerCellStyle.setFont(headerFont);
            int colCounter = 0;
            int rowCounter = 0;
            row = sheet.createRow(rowCounter++);
            HashMap<String, Class<?>> typeMap = this.initTypes();
            for (TableColumn col : this.tableView.getColumns()) {
                if (!col.isVisible()) continue;
                cell = row.createCell(colCounter++);
                cell.setCellValue(col.getText());
                cell.setCellStyle(headerCellStyle);
                Class<?> type = typeMap.get(col.getText());
                if (type == null) {
                    throw new IllegalStateException("No type found for column index \"" + (colCounter - 1) + "\"!");
                }
                if (!type.equals(Date.class) && !type.equals(Calendar.class) && !type.equals(LocalDate.class) && !type.equals(LocalDateTime.class)) continue;
                this.dateColumnIndexSet.add(colCounter - 1);
            }
            for (int rowIndex = 0; rowIndex < this.tableView.getItems().size() && rowIndex + 1 != SpreadsheetVersion.EXCEL2007.getMaxRows(); ++rowIndex) {
                row = sheet.createRow(rowCounter++);
                int colIndex = 0;
                for (TableColumn col : this.tableView.getColumns()) {
                    String value;
                    if (!col.isVisible()) continue;
                    cell = row.createCell(colIndex++);
                    Object cellData = col.getCellData(rowIndex);
                    if (!(cellData instanceof String) || (value = (String)cellData).isEmpty()) continue;
                    Class<?> type = typeMap.get(col.getText());
                    if (type.equals(Boolean.class)) {
                        cell.setCellValue(Boolean.valueOf(value).booleanValue());
                        continue;
                    }
                    if (type.equals(String.class) || type.equals(Enum.class) || type.equals(Character.class)) {
                        cell.setCellValue(value);
                        continue;
                    }
                    if (type.equals(Long.class)) {
                        cell.setCellValue((double)Long.parseLong(value));
                        continue;
                    }
                    if (type.equals(Date.class) || type.equals(Calendar.class)) {
                        try {
                            cell.setCellValue(this.dateTimeFormat.parse(value));
                            cell.setCellStyle(cellStyleDateTime);
                        }
                        catch (ParseException e) {
                            cell.setCellValue(this.dateFormat.parse(value));
                            cell.setCellStyle(cellStyleDate);
                        }
                        continue;
                    }
                    if (type.equals(Double.class) || type.equals(BigDecimal.class)) {
                        cell.setCellValue(this.decimalFormat.parse(value).doubleValue());
                        cell.setCellStyle(cellStyleDouble);
                        continue;
                    }
                    if (type.equals(LocalDate.class)) {
                        cell.setCellValue(this.dateFormat.parse(value));
                        cell.setCellStyle(cellStyleDate);
                        continue;
                    }
                    if (!type.equals(LocalDateTime.class)) continue;
                    cell.setCellValue(this.dateTimeFormat.parse(value));
                    cell.setCellStyle(cellStyleDateTime);
                }
            }
            for (Integer colId : this.dateColumnIndexSet) {
                sheet.autoSizeColumn(colId.intValue());
            }
            fileOutputStream = new FileOutputStream(file);
            workbook.write((OutputStream)fileOutputStream);
        }
        finally {
            if (workbook != null) {
                workbook.dispose();
            }
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException ex) {
                logger.warn("Could not close file output stream!", (Throwable)ex);
            }
        }
    }
}

