/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.presentation.token;

import java.awt.Font;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.elements.presentation.token.AbstractTokenWithTextLayout;
import net.sourceforge.jeuclid.elements.support.GraphicsSupport;
import net.sourceforge.jeuclid.elements.support.text.StringUtil;
import net.sourceforge.jeuclid.font.FontFactory;
import org.w3c.dom.Node;
import org.w3c.dom.mathml.MathMLGlyphElement;

public final class Mglyph
extends AbstractTokenWithTextLayout
implements MathMLGlyphElement {
    public static final String ELEMENT = "mglyph";
    private static final String ATTR_ALT = "alt";
    private static final String ATTR_FONTFAMILY = "fontfamily";
    private static final String ATTR_INDEX = "index";
    private static final long serialVersionUID = 1L;

    protected Node newNode() {
        return new Mglyph();
    }

    protected AttributedString textContentAsAttributedString(LayoutContext layoutContext) {
        AttributedString attributedString;
        String string = this.getFontfamily();
        String string2 = string == null ? "serif" : string.trim();
        Font font = FontFactory.getInstance().getFont(string2, 0, GraphicsSupport.getFontsizeInPoint(layoutContext));
        int n = this.getIndex();
        if (font.getFamily().equalsIgnoreCase(string2) && font.canDisplay(n)) {
            attributedString = new AttributedString(new String(new int[]{n}, 0, 1));
            attributedString.addAttribute(TextAttribute.FONT, font);
        } else {
            attributedString = StringUtil.convertStringtoAttributedString(this.getAlt(), this.getMathvariantAsVariant(), GraphicsSupport.getFontsizeInPoint(layoutContext), layoutContext);
        }
        return attributedString;
    }

    protected boolean isEmpty() {
        return false;
    }

    public String getAlt() {
        return this.getMathAttribute(ATTR_ALT);
    }

    public String getFontfamily() {
        return this.getMathAttribute(ATTR_FONTFAMILY);
    }

    public int getIndex() {
        return Integer.parseInt(this.getMathAttribute(ATTR_INDEX));
    }

    public void setAlt(String string) {
        this.setAttribute(ATTR_ALT, string);
    }

    public void setFontfamily(String string) {
        this.setAttribute(ATTR_FONTFAMILY, string);
    }

    public void setIndex(int n) {
        this.setAttribute(ATTR_INDEX, Integer.toString(n));
    }
}

