/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.dao.hibernate;

import it.openutils.dao.hibernate.HibernateDAO;
import it.openutils.hibernate.example.EnhancedExample;
import it.openutils.hibernate.example.FilterMetadata;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Order;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateObjectRetrievalFailureException;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HibernateDAOImpl<T, K extends Serializable>
extends HibernateDaoSupport
implements HibernateDAO<T, K> {
    private static Logger log = LoggerFactory.getLogger(HibernateDAOImpl.class);

    @Override
    public List<T> find(String query) {
        return this.getHibernateTemplate().find(query);
    }

    @Override
    public List<T> findAll() {
        return this.findAll(this.getDefaultOrder());
    }

    @Override
    public List<T> findAll(final Order[] orderProperties) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session ses) throws HibernateException {
                Criteria crit = ses.createCriteria(HibernateDAOImpl.this.getReferenceClass());
                if (null != orderProperties) {
                    for (int j = 0; j < orderProperties.length; ++j) {
                        crit.addOrder(orderProperties[j]);
                    }
                }
                return crit.list();
            }
        });
    }

    @Override
    public List<T> find(String query, Object obj, Type type) {
        return this.find(query, new Object[]{obj}, new Type[]{type});
    }

    @Override
    public List<T> find(final String query, final Object[] obj, final Type[] type) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session ses) throws HibernateException {
                return ses.createQuery(query).setParameters(obj, type).list();
            }
        });
    }

    @Override
    public T load(K key) {
        Object result = this.getHibernateTemplate().load(this.getReferenceClass(), key);
        Hibernate.initialize((Object)result);
        return (T)result;
    }

    @Override
    public T loadIfAvailable(K key) {
        Object result;
        try {
            result = this.getHibernateTemplate().load(this.getReferenceClass(), key);
            Hibernate.initialize((Object)result);
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
        catch (HibernateObjectRetrievalFailureException e) {
            if (e.getCause() instanceof ObjectNotFoundException) {
                return null;
            }
            throw e;
        }
        return (T)result;
    }

    @Override
    public void saveOrUpdate(T obj) {
        this.getHibernateTemplate().saveOrUpdate(obj);
    }

    @Override
    public void update(T obj) {
        this.getHibernateTemplate().update(obj);
    }

    @Override
    public boolean delete(K key) {
        return (Boolean)this.getHibernateTemplate().execute(new HibernateCallback((Serializable)key){
            final /* synthetic */ Serializable val$key;
            {
                this.val$key = serializable;
            }

            public Object doInHibernate(Session ses) throws HibernateException {
                ses.delete(ses.load(HibernateDAOImpl.this.getReferenceClass(), this.val$key));
                return true;
            }
        });
    }

    @Override
    public void refresh(T obj) {
        this.getHibernateTemplate().refresh(obj);
    }

    @Override
    public T merge(final T obj) {
        return (T)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session ses) throws HibernateException {
                return ses.merge(obj);
            }
        });
    }

    @Override
    public K save(T obj) {
        return (K)this.getHibernateTemplate().save(obj);
    }

    @Override
    public T findFilteredFirst(T filter) {
        return this.getFirstInCollection(this.findFiltered(filter, 1, 0));
    }

    @Override
    public List<T> findFiltered(T filter) {
        return this.findFiltered(filter, new HashMap<String, FilterMetadata>(0));
    }

    @Override
    public List<T> findFiltered(T filter, Order[] orderProperties) {
        return this.findFiltered(filter, orderProperties, new HashMap<String, FilterMetadata>(0), Integer.MAX_VALUE, 0);
    }

    @Override
    public List<T> findFiltered(T filter, Map<String, FilterMetadata> metadata) {
        return this.findFiltered(filter, metadata, Integer.MAX_VALUE, 0);
    }

    @Override
    public List<T> findFiltered(T filter, int maxResults, int page) {
        return this.findFiltered(filter, new HashMap<String, FilterMetadata>(0), maxResults, page);
    }

    @Override
    public List<T> findFiltered(T filter, Map<String, FilterMetadata> metadata, int maxResults, int page) {
        return this.findFiltered(filter, null, metadata, maxResults, page);
    }

    @Override
    public List<T> findFiltered(final T filter, Order[] customOrder, final Map<String, FilterMetadata> metadata, final int maxResults, final int page) {
        final Order[] orderProperties = customOrder != null && customOrder.length > 0 ? customOrder : this.getDefaultOrder();
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session ses) throws HibernateException {
                Criteria crit = ses.createCriteria(filter.getClass());
                crit.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
                crit.setMaxResults(maxResults);
                crit.setFirstResult(maxResults * page);
                if (null != orderProperties && orderProperties.length > 0) {
                    for (Order order : orderProperties) {
                        if (order == null) continue;
                        crit.addOrder(order);
                    }
                }
                EnhancedExample.create(crit, filter, metadata);
                return crit.list();
            }
        });
    }

    protected abstract Class<T> getReferenceClass();

    protected Order[] getDefaultOrder() {
        return new Order[0];
    }

    protected List<?> getNamedQuery(final String name, final int marResults) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session ses) throws HibernateException {
                Query q = ses.getNamedQuery(name);
                q.setMaxResults(marResults);
                return q.list();
            }
        });
    }

    protected List<?> getNamedQuery(final String name, final Serializable[] params, final int marResults) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session ses) throws HibernateException {
                Query q = ses.getNamedQuery(name);
                q.setMaxResults(marResults);
                if (null != params) {
                    for (int i = 0; i < params.length; ++i) {
                        q.setParameter(i, (Object)params[i]);
                    }
                }
                return q.list();
            }
        });
    }

    protected List<?> getNamedQuery(final String name, final Map params, final int marResults) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session ses) throws HibernateException {
                Query q = ses.getNamedQuery(name);
                q.setMaxResults(marResults);
                if (params != null) {
                    for (Map.Entry entry : params.entrySet()) {
                        HibernateDAOImpl.this.setParameterValue(q, (String)entry.getKey(), entry.getValue());
                    }
                }
                return q.list();
            }
        });
    }

    protected void setParameterValue(Query query, String key, Object value) {
        if (null == key || null == value) {
            return;
        }
        query.setParameter(key, value);
    }

    private T getFirstInCollection(Collection<T> list) {
        if (list != null && !list.isEmpty()) {
            T result = list.iterator().next();
            Hibernate.initialize(result);
            return result;
        }
        return null;
    }
}

