/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.hibernate.example;

import it.openutils.dao.hibernate.MutableDateRange;
import it.openutils.hibernate.example.FilterMetadata;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.dao.DataRetrievalFailureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnhancedExample {
    private Map<String, FilterMetadata> metadata;
    private static Log log = LogFactory.getLog(EnhancedExample.class);

    private EnhancedExample(Criteria crit, Object filter, Map<String, FilterMetadata> metadata) {
        this.metadata = metadata == null ? new HashMap(0) : metadata;
        this.fillCriteria(crit, filter);
    }

    public static void create(Criteria crit, Object filter, Map<String, FilterMetadata> metadata) throws HibernateException {
        new EnhancedExample(crit, filter, metadata);
    }

    private void addCondition(Criteria crit, String propertyName, Object value, Object parentObject) throws HibernateException {
        if (this.isSimpleType(value)) {
            if (value instanceof String && StringUtils.isBlank((String)((String)value))) {
                return;
            }
            FilterMetadata fmd = this.metadata.get(propertyName);
            if (fmd == null) {
                fmd = FilterMetadata.EQUAL;
            }
            fmd.createFilter(crit, propertyName, value);
        } else if (value instanceof MutableDateRange) {
            Date from = ((MutableDateRange)value).getFrom();
            Date to = ((MutableDateRange)value).getTo();
            if (from != null && to != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("crit.add(Restrictions.between(" + propertyName + "," + from + ", " + to + ")"));
                }
                crit.add(Restrictions.between((String)propertyName, (Object)from, (Object)to));
            } else if (from != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("crit.add(Restrictions.ge(" + propertyName + "," + from + ")"));
                }
                crit.add((Criterion)Restrictions.ge((String)propertyName, (Object)from));
            } else if (to != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("crit.add(Restrictions.le(" + propertyName + ", " + to + ")"));
                }
                crit.add((Criterion)Restrictions.le((String)propertyName, (Object)to));
            }
        } else if (this.containsSomething(value)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("crit.createCriteria(" + propertyName + ")"));
            }
            if ((value instanceof Set || value instanceof List) && !((Collection)value).isEmpty()) {
                Iterator iterator = ((Collection)value).iterator();
                if (iterator.hasNext()) {
                    Object element = iterator.next();
                    Criteria childrenCriteria = crit.createCriteria(propertyName);
                    this.fillCriteria(childrenCriteria, element);
                }
            } else {
                Criteria childrenCriteria = crit.createCriteria(propertyName);
                this.fillCriteria(childrenCriteria, value);
            }
        }
    }

    private boolean containsSomething(Object bean) {
        Map properties;
        Object coll;
        if (bean == null) {
            return false;
        }
        if (this.isSimpleType(bean)) {
            return true;
        }
        if (bean instanceof MutableDateRange) {
            return ((MutableDateRange)bean).isSet();
        }
        if (bean instanceof Collection) {
            coll = (Collection)bean;
            if (coll.isEmpty()) {
                return false;
            }
            if (this.containsSomething(coll.iterator().next())) {
                return true;
            }
        } else if (bean instanceof Map) {
            coll = (Map)bean;
            if (coll.isEmpty()) {
                return false;
            }
            if (this.containsSomething(coll.values().iterator().next())) {
                return true;
            }
        }
        try {
            properties = PropertyUtils.describe((Object)bean);
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            log.error((Object)("Unable to build filter, PropertyUtils.describe throws an exception while analizing class " + ClassUtils.getShortClassName((Object)bean, (String)"NULL")), e);
            return false;
        }
        for (Map.Entry property : properties.entrySet()) {
            Object propertyValue;
            if (!PropertyUtils.isWriteable((Object)bean, (String)((String)property.getKey())) || (propertyValue = property.getValue()) == null || !this.isSimpleType(propertyValue) && !this.containsSomething(propertyValue)) continue;
            return true;
        }
        if (log.isDebugEnabled()) {
            // empty if block
        }
        return false;
    }

    private void fillCriteria(Criteria crit, Object filter) throws HibernateException {
        Map properties;
        if ((filter instanceof Set || filter instanceof List) && !((Collection)filter).isEmpty()) {
            for (Object element : (Collection)filter) {
                this.fillCriteria(crit, element);
            }
        }
        try {
            properties = PropertyUtils.describe((Object)filter);
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            throw new DataRetrievalFailureException("Unable to build filter, PropertyUtils.describe throws an exception while analizing class " + ClassUtils.getShortClassName((Object)filter, (String)"NULL") + ":" + e.getClass(), e);
        }
        for (String propertyName : properties.keySet()) {
            Object value = properties.get(propertyName);
            if (value == null || !PropertyUtils.isWriteable((Object)filter, (String)propertyName)) continue;
            this.addCondition(crit, propertyName, value, filter);
        }
    }

    private boolean isSimpleType(Object object) {
        Class<?> objClass = object.getClass();
        return objClass.isPrimitive() || objClass.equals(Integer.class) || objClass.equals(Long.class) || objClass.equals(Short.class) || objClass.equals(Boolean.class) || objClass.equals(String.class) || objClass.equals(Double.class) || objClass.equals(Float.class) || objClass.equals(Date.class) || objClass.equals(Byte.class) || objClass.equals(BigDecimal.class) || objClass.equals(Timestamp.class) || objClass.equals(Character.class) || objClass.equals(Calendar.class);
    }
}

