/*
 * Copyright Openmind http://www.openmindonline.it
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sourceforge.openutils.elfunctions;

import org.apache.commons.lang.StringUtils;


/**
 * Utility methods mapped to EL functions to allow usage in jsp pages.
 * @author fgiust
 * @version $Id: ElStringUtils.java 951 2008-12-11 16:37:40Z fgiust $
 */
public class ElStringUtils
{

    /**
     * The space character.
     * @return the space character
     */
    public static String space()
    {
        return " ";
    }

    /**
     * The tab character.
     * @return the tab character
     */
    public static String tab()
    {
        return "\t";
    }

    /**
     * The newline (<code>\n</code>) character.
     * @return the newline (<code>\n</code>) character
     */
    public static String newline()
    {
        return "\n";
    }

    public static String escapeJsText(String text, boolean dbl)
    {
        String repl = dbl ? "\"" : "'";
        String with = "\\" + repl;
        return repl + (text != null ? StringUtils.replace(text, repl, with) : "") + repl;
    }

    public static String adaptStringLength(String value, int maxLength, String ellipses)
    {
        if (value != null && value.length() > maxLength)
        {
            return value.substring(0, maxLength) + ellipses;
        }

        return value;
    }

    public static String stripHtmlTags(String string)
    {
        if (StringUtils.isNotBlank(string))
        {
            return StringUtils.remove(StringUtils.remove(string.replaceAll("<(.|\n)+?>", ""), '\r'), '\n').trim();

        }
        return null;
    }

    /**
     * Splits the given strings on newlines (<code>\n</code>)
     * @param string string to be splitted
     * @return splitted string
     */
    public static String[] splitNewlines(String string)
    {
        return StringUtils.splitPreserveAllTokens(string, '\n');
    }

    /**
     * Splits the given strings on tabs (<code>\t</code>)
     * @param string string to be splitted
     * @return splitted string
     */
    public static String[] splitOnTabs(String string)
    {
        return StringUtils.splitPreserveAllTokens(string, '\t');
    }

    /**
     * Tests if this string ends with the specified suffix.
     * @param string
     * @param suffix
     * @return true if the string ends with the suffix, false otherwise
     */
    public static boolean endsWith(String string, String suffix)
    {
        return string.endsWith(suffix);
    }

}
