/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlcontextmenu.configuration;

import info.magnolia.jcr.util.MetaDataUtil;
import info.magnolia.jcr.util.PropertyUtil;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import net.sourceforge.openutils.mgnlcontextmenu.configuration.PersistenceStrategy;
import net.sourceforge.openutils.mgnlcontextmenu.configuration.Scope;
import org.apache.commons.lang.StringUtils;

public class DefaultPersistenceStrategy
extends PersistenceStrategy {
    public String readEntry(Node node, String name, Scope scope) {
        switch (scope) {
            case local: {
                return PropertyUtil.getString((Node)node, (String)name);
            }
            case global: {
                Node globalNode = this.getGlobalNode(node);
                return PropertyUtil.getString((Node)globalNode, (String)name);
            }
        }
        return null;
    }

    public void writeEntry(Node node, String name, String value, Scope scope) throws RepositoryException {
        switch (scope) {
            case local: {
                this.setOrDelete(node, name, value);
                break;
            }
            case global: {
                Node globalNode = this.getGlobalNode(node);
                this.setOrDelete(globalNode, name, value);
                MetaDataUtil.updateMetaData((Node)globalNode);
            }
        }
    }

    protected void setOrDelete(Node node, String name, String value) throws RepositoryException {
        if (!StringUtils.isEmpty((String)value)) {
            node.setProperty(name, value);
        } else if (node.hasProperty(name)) {
            node.getProperty(name).remove();
        }
    }
}

