/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlcontextmenu.setup;

import info.magnolia.cms.core.HierarchyManager;
import info.magnolia.cms.core.Path;
import info.magnolia.module.InstallContext;
import info.magnolia.module.delta.AbstractTask;
import info.magnolia.module.delta.TaskExecutionException;
import info.magnolia.module.files.FileExtractionLogger;
import info.magnolia.module.files.FileExtractor;
import info.magnolia.module.files.MD5CheckingFileExtractor;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

public class FilesExtractionTask
extends AbstractTask {
    public FilesExtractionTask(String taskName, String taskDescription) {
        super(taskName, taskDescription);
    }

    public FilesExtractionTask() {
        this("Files extraction", "Extracts files to webapp root.");
    }

    public void execute(final InstallContext ctx) throws TaskExecutionException {
        HierarchyManager hm = ctx.getConfigHierarchyManager();
        MD5CheckingFileExtractor extractor = new MD5CheckingFileExtractor(new FileExtractionLogger(){

            public void error(String message) {
                ctx.warn(message);
            }
        }, hm);
        try {
            extractor.extractFiles(new FileExtractor.Transformer(){

                public String accept(String resourcePath) {
                    if (!FilesExtractionTask.this.accept(resourcePath)) {
                        return null;
                    }
                    String relTargetPath = StringUtils.removeStart((String)resourcePath, (String)"/mgnl-files/");
                    return Path.getAbsoluteFileSystemPath((String)relTargetPath);
                }
            });
        }
        catch (IOException e) {
            throw new TaskExecutionException("Could not extract files for module " + ctx.getCurrentModuleDefinition() + ": " + e.getMessage(), (Throwable)e);
        }
    }

    protected boolean accept(String resource) {
        return resource.startsWith("/mgnl-files/");
    }
}

