/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlcontextmenu.configuration;

import info.magnolia.cms.beans.config.ObservedManager;
import info.magnolia.cms.core.Content;
import info.magnolia.cms.util.ContentUtil;
import info.magnolia.cms.util.NodeDataUtil;
import info.magnolia.objectfactory.Components;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Singleton;
import javax.jcr.RepositoryException;
import net.sourceforge.openutils.mgnlcontextmenu.configuration.ContextMenu;
import net.sourceforge.openutils.mgnlcontextmenu.configuration.ContextMenuItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class ContextMenuManager
extends ObservedManager {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final List<ContextMenu> menus = new ArrayList<ContextMenu>();

    public static ContextMenuManager getInstance() {
        return (ContextMenuManager)((Object)Components.getSingleton(ContextMenuManager.class));
    }

    public List<ContextMenu> getMenus() {
        return this.menus;
    }

    protected void onClear() {
        this.menus.clear();
    }

    protected void onRegister(Content defNode) {
        for (Content menuNode : ContentUtil.getAllChildren((Content)defNode)) {
            ContextMenu menu = new ContextMenu();
            menu.setName(menuNode.getName());
            try {
                if (menuNode.hasContent("items")) {
                    Content itemsNode = menuNode.getContent("items");
                    for (Content itemNode : ContentUtil.getAllChildren((Content)itemsNode)) {
                        ContextMenuItem item = new ContextMenuItem();
                        item.setName(itemNode.getName());
                        item.setControlType(NodeDataUtil.getString((Content)itemNode, (String)"controlType"));
                        item.setIcon(NodeDataUtil.getString((Content)itemNode, (String)"icon"));
                        item.setText(NodeDataUtil.getString((Content)itemNode, (String)"text"));
                        item.setGlobalEnabled(NodeDataUtil.getBoolean((Content)itemNode, (String)"globalEnabled", (boolean)false));
                        menu.getItems().add(item);
                    }
                }
            }
            catch (RepositoryException e) {
                this.log.error("Cannot get items of menu " + menu.getName(), (Throwable)e);
            }
            menu.setMouseoverClass(NodeDataUtil.getString((Content)menuNode, (String)"mouseoverClass"));
            menu.setMouseoverIcon(NodeDataUtil.getString((Content)menuNode, (String)"mouseoverIcon"));
            this.menus.add(menu);
        }
    }
}

