/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlcontextmenu.configuration;

import info.magnolia.context.MgnlContext;
import info.magnolia.jcr.util.MetaDataUtil;
import info.magnolia.jcr.util.PropertyUtil;
import it.openutils.mgnlutils.el.MgnlUtilsElFunctions;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.openutils.mgnlcontextmenu.configuration.PersistenceStrategy;
import net.sourceforge.openutils.mgnlcontextmenu.configuration.Scope;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridPersistenceStrategy
extends PersistenceStrategy {
    private static Logger log = LoggerFactory.getLogger(GridPersistenceStrategy.class);
    private static final String LOCAL_CACHE_KEY = GridPersistenceStrategy.class.getName() + ".localCache";
    private static final String GLOBAL_CACHE_KEY = GridPersistenceStrategy.class.getName() + ".globalCache";
    public static final String LOCAL_PROPERTY_NAME = "localGrid";
    public static final String GLOBAL_PROPERTY_NAME = "globalGrid";

    @Override
    public String readEntry(Node node, String name, Scope scope) {
        switch (scope) {
            case local: {
                return this.getLocalEntries(node).get(name);
            }
            case global: {
                return this.getGlobalEntries(node).get(name);
            }
        }
        return null;
    }

    @Override
    public void writeEntry(Node node, String name, String value, Scope scope) throws RepositoryException {
        switch (scope) {
            case local: {
                this.update(node, LOCAL_PROPERTY_NAME, name, value, this.getLocalEntries(node), false);
                break;
            }
            case global: {
                Node globalNode = this.getGlobalNode(node);
                this.update(globalNode, GLOBAL_PROPERTY_NAME, name, value, this.getGlobalEntries(node), true);
            }
        }
    }

    protected Map<String, String> getGlobalEntries(Node node) {
        ServletContext servletContext = MgnlContext.getWebContext().getServletContext();
        HashMap<String, GlobalCache> map = (HashMap<String, GlobalCache>)servletContext.getAttribute(GLOBAL_CACHE_KEY);
        if (map == null) {
            map = new HashMap<String, GlobalCache>();
            servletContext.setAttribute(GLOBAL_CACHE_KEY, map);
        }
        Node globalNode = this.getGlobalNode(node);
        String mapKey = "";
        try {
            mapKey = globalNode.getIdentifier();
        }
        catch (UnsupportedOperationException e) {
            log.error(e.getMessage());
        }
        catch (RepositoryException re) {
            log.error("Exception caught", (Throwable)re);
        }
        GlobalCache globalCache = (GlobalCache)map.get(mapKey);
        Calendar modificationDate = MetaDataUtil.getMetaData((Node)globalNode).getModificationDate();
        if (globalCache != null && globalCache.getCreationDate().compareTo(modificationDate) < 0) {
            globalCache = null;
        }
        if (globalCache == null) {
            globalCache = new GlobalCache(modificationDate);
            GridPersistenceStrategy.collectEntries(globalNode, GLOBAL_PROPERTY_NAME, globalCache.getEntries());
            map.put(mapKey, globalCache);
        }
        return globalCache.getEntries();
    }

    protected Map<String, String> getLocalEntries(Node node) {
        HttpServletRequest request = MgnlContext.getWebContext().getRequest();
        HashMap<String, HashMap<String, String>> map = (HashMap<String, HashMap<String, String>>)request.getAttribute(LOCAL_CACHE_KEY);
        if (map == null) {
            map = new HashMap<String, HashMap<String, String>>();
            request.setAttribute(LOCAL_CACHE_KEY, map);
        }
        String mapKey = "";
        try {
            mapKey = node.getIdentifier();
        }
        catch (UnsupportedOperationException e) {
            log.error(e.getMessage());
        }
        catch (RepositoryException re) {
            log.error("Exception caught", (Throwable)re);
        }
        HashMap<String, String> contents = (HashMap<String, String>)map.get(mapKey);
        if (contents == null) {
            contents = new HashMap<String, String>();
            GridPersistenceStrategy.collectEntries(node, LOCAL_PROPERTY_NAME, contents);
            map.put(mapKey, contents);
        }
        return contents;
    }

    private static void collectEntries(Node node, String propertyName, Map<String, String> entries) {
        String propertyValue = PropertyUtil.getString((Node)node, (String)propertyName);
        if (!StringUtils.isEmpty((String)propertyValue)) {
            for (String[] entry : MgnlUtilsElFunctions.splitAndTokenize((String)propertyValue)) {
                if (entry.length < 2) continue;
                entries.put(entry[0], entry[1]);
            }
        }
    }

    private void update(Node node, String propertyName, String name, String value, Map<String, String> entries, boolean updateMetaData) throws RepositoryException {
        boolean changed;
        boolean bl = StringUtils.isEmpty((String)(value = StringUtils.remove((String)StringUtils.replaceChars((String)value, (String)"\n\t", (String)"  "), (char)'\r'))) ? entries.containsKey(name) : (changed = !value.equals(entries.get(name)));
        if (changed) {
            String propertyValue = PropertyUtil.getString((Node)node, (String)propertyName);
            String[][] array = StringUtils.isEmpty((String)propertyValue) ? new String[][]{} : MgnlUtilsElFunctions.splitAndTokenize((String)propertyValue);
            StringBuilder sb = new StringBuilder();
            boolean found = false;
            for (int i = 0; i < array.length; ++i) {
                if (StringUtils.equals((String)name, (String)array[i][0])) {
                    found = true;
                    if (StringUtils.isEmpty((String)value)) continue;
                    if (sb.length() > 0) {
                        sb.append('\n');
                    }
                    sb.append(name).append('\t').append(value);
                    continue;
                }
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append(array[i][0]).append('\t').append(array[i][1]);
            }
            if (!found && !StringUtils.isEmpty((String)value)) {
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append(name).append('\t').append(value);
            }
            node.setProperty(propertyName, new String(sb));
            if (updateMetaData) {
                MetaDataUtil.updateMetaData((Node)node);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GlobalCache {
        private final Calendar creationDate;
        private final Map<String, String> entries = new HashMap<String, String>();

        public GlobalCache(Calendar creationDate) {
            this.creationDate = creationDate;
        }

        public Calendar getCreationDate() {
            return this.creationDate;
        }

        public Map<String, String> getEntries() {
            return this.entries;
        }
    }
}

