/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlcontextmenu.el;

import info.magnolia.context.MgnlContext;
import info.magnolia.context.WebContext;
import info.magnolia.jcr.util.NodeUtil;
import info.magnolia.jcr.wrapper.HTMLEscapingNodeWrapper;
import info.magnolia.objectfactory.Components;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import javax.jcr.Node;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.openutils.mgnlcontextmenu.configuration.PersistenceStrategy;
import net.sourceforge.openutils.mgnlcontextmenu.module.ContextMenuModule;
import net.sourceforge.openutils.mgnlcontextmenu.tags.ElementInfo;
import net.sourceforge.openutils.mgnlcontextmenu.tags.MenuScripts;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextMenuElFunctions {
    private static Logger log = LoggerFactory.getLogger(ContextMenuElFunctions.class);
    public static final String SORT_LIST_KEY = "mgnlSortLists";
    private static final String EDIT_MESSAGE_INFOS_KEY = "mgnlEditMessageInfos";

    private static HttpServletRequest getRequest() {
        return ((WebContext)MgnlContext.getInstance()).getRequest();
    }

    public static String entryValue(Node node, String name) {
        if (node == null) {
            return null;
        }
        ContextMenuModule module = (ContextMenuModule)Components.getComponent(ContextMenuModule.class);
        PersistenceStrategy strategy = module.getPersistenceStrategy();
        Node nodeUnwrapped = NodeUtil.deepUnwrap((Node)node, HTMLEscapingNodeWrapper.class);
        String result = strategy != null ? strategy.readEntry(nodeUnwrapped, name) : null;
        return result;
    }

    public static String scripts() {
        return MenuScripts.write();
    }

    public static String links() {
        String ctx = MgnlContext.getContextPath();
        boolean canEdit = NodeUtil.isGranted((Node)MgnlContext.getAggregationState().getMainContent().getJCRNode(), (long)2L);
        StringBuilder out = new StringBuilder();
        if (canEdit) {
            out.append("<!-- start contextmenu:links -->\n");
            out.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + ctx + "/.resources/contextmenu/css/jquery.contextMenu.css\" media=\"screen\" />\n");
            out.append("<script src=\"" + ctx + "/.resources/contextmenu/js/mgnladmin-custom.js\"></script>\n");
            out.append("<script src=\"" + ctx + "/.resources/contextmenu/js/jquery.contextMenu.js\"></script>\n");
            out.append("<script src=\"" + ctx + "/.resources/contextmenu/js/contextmenu-addMenu.js\"></script>\n");
            out.append("<script src=\"" + ctx + "/.resources/contextmenu/js/contextmenu-sortList.js\"></script>\n");
            out.append("<!-- end contextmenu:links -->\n");
        }
        return out.toString();
    }

    private static Stack getSortListStack() {
        HttpServletRequest request = ContextMenuElFunctions.getRequest();
        Stack stack = (Stack)request.getAttribute("SORT_LIST_STACK");
        if (stack == null) {
            stack = new Stack();
            request.setAttribute("SORT_LIST_STACK", stack);
        }
        return stack;
    }

    public static void beginSortList() {
        ContextMenuElFunctions.getSortListStack().push(new ArrayList());
    }

    public static void addSortListItem(String html) {
        ((List)ContextMenuElFunctions.getSortListStack().peek()).add(html);
    }

    public static List endSortList(String order) {
        String[] tokens = StringUtils.splitPreserveAllTokens((String)order, (char)',');
        List input = (List)ContextMenuElFunctions.getSortListStack().pop();
        ArrayList<String> output = new ArrayList<String>(input.size());
        int i = 0;
        for (String html : input) {
            int index = i < tokens.length ? NumberUtils.toInt((String)tokens[i], (int)-1) : -1;
            output.add((String)(index >= 0 && index < input.size() ? input.get(index) : html));
            ++i;
        }
        return output;
    }

    public static void init() {
        ArrayList items;
        HttpServletRequest request = ContextMenuElFunctions.getRequest();
        ArrayList list = (ArrayList)request.getAttribute(EDIT_MESSAGE_INFOS_KEY);
        if (list == null) {
            list = new ArrayList();
            request.setAttribute(EDIT_MESSAGE_INFOS_KEY, list);
        }
        if ((items = (ArrayList)request.getAttribute(SORT_LIST_KEY)) == null) {
            items = new ArrayList();
            request.setAttribute(SORT_LIST_KEY, items);
        }
    }

    public static ElementInfo addEditMessageInfo(String key, String path, String elementId) {
        HttpServletRequest request = ContextMenuElFunctions.getRequest();
        ArrayList<ElementInfo> list = (ArrayList<ElementInfo>)request.getAttribute(EDIT_MESSAGE_INFOS_KEY);
        if (list == null) {
            list = new ArrayList<ElementInfo>();
            request.setAttribute(EDIT_MESSAGE_INFOS_KEY, list);
        }
        ElementInfo item = new ElementInfo(key, path, elementId);
        list.add(item);
        return item;
    }

    public static List editMessageInfos() {
        List list = (List)ContextMenuElFunctions.getRequest().getAttribute(EDIT_MESSAGE_INFOS_KEY);
        return list != null ? list : Collections.EMPTY_LIST;
    }

    public static String editMessageInfosJs() {
        StringBuilder sb = new StringBuilder();
        for (Object item : ContextMenuElFunctions.editMessageInfos()) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            ElementInfo info = (ElementInfo)item;
            sb.append("'").append(info.getElementId()).append("'");
            sb.append(":{");
            if (!StringUtils.isEmpty((String)info.getParentTrigger())) {
                sb.append("'parentTrigger':'").append(info.getParentTrigger()).append("',");
            }
            if (!StringUtils.isEmpty((String)info.getEntryName())) {
                sb.append("'entryName':'").append(info.getEntryName()).append("',");
            }
            if (!StringUtils.isEmpty((String)info.getContextMenu())) {
                sb.append("'contextMenu':'").append(info.getContextMenu()).append("',");
            }
            if (!StringUtils.isEmpty((String)info.getEnterMode())) {
                sb.append("'enterMode':'").append(info.getEnterMode()).append("',");
            }
            if (!StringUtils.isEmpty((String)info.getShowCallback())) {
                sb.append("'showCallback':").append(info.getShowCallback()).append(',');
            }
            sb.append("'key':'").append(info.getKey()).append("',");
            sb.append("'path':'").append(info.getPath()).append("'");
            sb.append('}');
        }
        return "{" + sb + "}";
    }
}

