/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlcontextmenu.tags;

import info.magnolia.context.MgnlContext;
import info.magnolia.jcr.util.NodeUtil;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import net.sourceforge.openutils.mgnlcontextmenu.configuration.ContextMenu;
import net.sourceforge.openutils.mgnlcontextmenu.configuration.ContextMenuItem;
import net.sourceforge.openutils.mgnlcontextmenu.configuration.ContextMenuManager;
import net.sourceforge.openutils.mgnlcontextmenu.el.ContextMenuElFunctions;
import net.sourceforge.openutils.mgnlcontextmenu.tags.ElementInfo;
import net.sourceforge.openutils.mgnlcontextmenu.tags.ElementTag;
import org.apache.commons.lang.StringUtils;

public class MenuScripts {
    public static String write() {
        if (MenuScripts.canEdit()) {
            StringBuilder out = new StringBuilder();
            out.append("<script type=\"text/javascript\">\n");
            out.append("var mgnlContextMenuInfo = {\n");
            out.append("  contextPath: '" + MgnlContext.getContextPath() + "',\n");
            out.append("  menus: " + MenuScripts.menusJs() + ",\n");
            out.append("  elements: " + MenuScripts.elementsJs() + "\n");
            out.append("};\n");
            out.append("</script>\n");
            out.append("<!-- start contextmenu:scripts -->\n");
            out.append("<script type=\"text/javascript\">\n");
            out.append("jQuery(document).ready(function() {\n");
            out.append("  jQuery.mgnlAddContextMenu(" + ContextMenuElFunctions.editMessageInfosJs() + ", mgnlContextMenuInfo );\n");
            out.append("});\n");
            out.append("</script>\n");
            out.append("<!-- end contextmenu:scripts -->\n");
            out.append("<!-- start sortList script -->\n");
            out.append("<script type=\"text/javascript\">\n");
            out.append("jQuery(document).ready(function() {\n");
            List items = (List)MgnlContext.getWebContext().getRequest().getAttribute("mgnlSortLists");
            if (items != null) {
                for (Map item : items) {
                    out.append("jQuery('#" + (String)item.get("containerId") + "').sortList({\n");
                    out.append(" url: '" + (String)item.get("url") + "',\n");
                    out.append(" path: '" + (String)item.get("path") + "',\n");
                    out.append(" name: '" + (String)item.get("name") + "',\n");
                    out.append(" order: " + (String)item.get("order") + "\n");
                    out.append("});\n");
                }
            }
            out.append("});\n");
            out.append("</script>\n");
            out.append("<!-- end sortList script -->\n");
            return out.toString();
        }
        return "";
    }

    private static String menusJs() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (ContextMenu menu : ContextMenuManager.getInstance().getMenus()) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append("{");
            sb.append("'name':'").append(menu.getName()).append("',");
            sb.append("'items':[");
            int j = 0;
            for (ContextMenuItem item : menu.getItems()) {
                if (j > 0) {
                    sb.append(',');
                }
                sb.append("{");
                sb.append("'name':'").append(item.getName()).append("'");
                sb.append(",'controlType':'").append(item.getControlType()).append("'");
                sb.append(",'icon':'").append(item.getIcon()).append("'");
                sb.append(",'text':'").append(item.getText()).append("'");
                sb.append(",'globalEnabled':").append(item.isGlobalEnabled());
                sb.append("}");
                ++j;
            }
            sb.append("],");
            sb.append("'mouseoverClass':'").append(StringUtils.defaultString((String)menu.getMouseoverClass())).append("',");
            sb.append("'mouseoverIcon':'").append(StringUtils.defaultString((String)menu.getMouseoverIcon())).append("'");
            sb.append("}");
            ++i;
        }
        return "[" + sb + "]";
    }

    private static String elementsJs() {
        StringBuilder sb = new StringBuilder();
        List infos = (List)MgnlContext.getWebContext().getRequest().getAttribute(ElementTag.ELEMENT_INFOS_KEY);
        if (infos != null) {
            for (Object item : infos) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                ElementInfo info = (ElementInfo)item;
                sb.append("'").append(info.getElementId()).append("'");
                sb.append(":{");
                if (!StringUtils.isEmpty((String)info.getContextMenu())) {
                    sb.append("'contextMenu':'").append(info.getContextMenu()).append("',");
                }
                if (!StringUtils.isEmpty((String)info.getParentTrigger())) {
                    sb.append("'parentTrigger':'").append(info.getParentTrigger()).append("',");
                }
                if (!StringUtils.isEmpty((String)info.getEnterMode())) {
                    sb.append("'enterMode':'").append(info.getEnterMode()).append("',");
                }
                sb.append("'path':'").append(info.getPath()).append("'");
                sb.append('}');
            }
        }
        return "{" + sb + "}";
    }

    private static boolean canEdit() {
        return NodeUtil.isGranted((Node)MgnlContext.getAggregationState().getMainContent().getJCRNode(), (long)2L);
    }
}

