/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlcontrols.dialog;

import freemarker.template.TemplateException;
import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.ItemType;
import info.magnolia.cms.core.NodeData;
import info.magnolia.cms.core.SystemProperty;
import info.magnolia.cms.gui.control.FreemarkerControl;
import info.magnolia.cms.gui.dialog.DialogBox;
import info.magnolia.cms.gui.dialog.DialogFreemarker;
import info.magnolia.cms.security.AccessDeniedException;
import info.magnolia.cms.util.NodeDataUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.exception.NestableRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigurableFreemarkerDialog
extends DialogBox {
    private static Logger log = LoggerFactory.getLogger(DialogFreemarker.class);
    private Map configuration;
    private String uuid;

    protected Map getSubNodes(Content node) throws RepositoryException, AccessDeniedException {
        Collection children;
        this.uuid = node.getUUID();
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        Collection properties = node.getNodeDataCollection();
        if (properties != null && properties.size() > 0) {
            for (NodeData property : properties) {
                values.put(property.getName(), NodeDataUtil.getValueObject((NodeData)property));
            }
        }
        if ((children = node.getChildren(ItemType.CONTENTNODE)) != null && children.size() > 0) {
            for (Content child : children) {
                Map subValues = this.getSubNodes(child);
                values.put(child.getName(), subValues);
            }
        }
        return values;
    }

    public void init(HttpServletRequest request, HttpServletResponse response, Content websiteNode, Content configNode) throws RepositoryException {
        super.init(request, response, websiteNode, configNode);
        this.configuration = this.getSubNodes(configNode);
    }

    public void drawHtml(Writer out) throws IOException {
        String alreadyRenderedKey = "freemarker/" + this.getPath();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("name", this.getName());
        parameters.put("value", this.getValue());
        parameters.put("values", this.getValues());
        parameters.put("request", this.getRequest());
        parameters.put("debug", SystemProperty.getBooleanProperty((String)"magnolia.develop"));
        parameters.put("configuration", this.configuration);
        parameters.put("uuid", this.uuid);
        parameters.put("alreadyrendered", this.getRequest().getAttribute(alreadyRenderedKey) != null);
        this.addToParameters(parameters);
        this.drawHtmlPre(out);
        try {
            FreemarkerControl control = new FreemarkerControl("multiple".equals(this.getConfigValue("valueType")) ? 1 : 0);
            control.setType(this.getConfigValue("type", "String"));
            control.setName(this.getName());
            control.drawHtml(out, this.getPath(), parameters);
        }
        catch (TemplateException ex) {
            log.error("Error processing dialog template:", (Throwable)ex);
            throw new NestableRuntimeException((Throwable)ex);
        }
        this.drawHtmlPost(out);
        this.getRequest().setAttribute(alreadyRenderedKey, (Object)Boolean.TRUE);
    }

    protected void addToParameters(Map parameters) {
    }

    protected abstract String getPath();
}

