package info.magnolia.cms.i18n;

import net.sourceforge.openutils.mgnlmessages.i18n.ModulePropertyMessagesImpl;
import net.sourceforge.openutils.mgnlmessages.i18n.RepositoryMessagesImpl;


/**
 * @author molaschi
 * @version $Id: $
 */
public class OpenutilsMgnlMessagesManager extends DefaultMessagesManager
{

    /**
     * {@inheritDoc}
     */
    @Override
    protected Messages newMessages(MessagesID messagesID)
    {
        Messages msgs = new MessagesChain(new RepositoryMessagesImpl(messagesID.getBasename(), messagesID.getLocale()));
        ((MessagesChain) msgs).chain(new ModulePropertyMessagesImpl(messagesID.getLocale()));
        ((MessagesChain) msgs).chain(new DefaultMessagesImpl(messagesID.getBasename(), messagesID.getLocale()));

        if (!getDefaultLocale().equals(messagesID.getLocale()))
        {
            msgs = ((MessagesChain) msgs).chain(MessagesManager.getMessages(
                messagesID.getBasename(),
                getDefaultLocale()));
        }
        return msgs;
    }

}
