package net.sourceforge.openutils.mgnlmessages.i18n;

import info.magnolia.cms.i18n.AbstractMessagesImpl;
import info.magnolia.cms.i18n.Messages;
import info.magnolia.module.ModuleRegistry;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;


/**
 * @author molaschi
 * @version $Id: $
 */
public class ModulePropertyMessagesImpl extends AbstractMessagesImpl
{

    List<Messages> messages = new ArrayList<Messages>();

    /**
     * @param basename
     * @param locale
     */
    @SuppressWarnings("unchecked")
    public ModulePropertyMessagesImpl(Locale locale)
    {
        super("", locale);
        ModuleRegistry reg = ModuleRegistry.Factory.getInstance();
        for (String name : (Set<String>) reg.getModuleNames())
        {
            messages.add(new SimpleMessagesImpl("mgnl-messages." + name + ".messages", locale));
        }
    }

    /**
     * {@inheritDoc}
     */
    public String get(String key)
    {
        String value;
        for (Messages m : messages)
        {
            value = m.get(key);
            if (value != null)
            {
                return value;
            }
        }
        if (key == null)
        {
            return "??????";
        }
        return "???" + key + "???";
    }

    /**
     * {@inheritDoc}
     */
    @SuppressWarnings("unchecked")
    public Iterator keys()
    {
        List<String> keys = new ArrayList<String>();
        for (Messages m : messages)
        {
            Iterator it = m.keys();
            while (it.hasNext())
            {
                keys.add((String) it.next());
            }
        }
        return keys.iterator();
    }

    /**
     * {@inheritDoc}
     */
    public void reload() throws Exception
    {
        for (Messages m : messages)
        {
            m.reload();
        }
    }

}
