package net.sourceforge.openutils.mgnlmessages.lifecycle;

import info.magnolia.module.ModuleLifecycle;
import info.magnolia.module.ModuleLifecycleContext;
import net.sourceforge.openutils.mgnlmessages.configuration.MessagesConfigurationManager;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * @author molaschi
 */
public class MessagesModuleLifecycle implements ModuleLifecycle
{

    /**
     *
     */
    public static final String REPO = "messages";

    private Logger log = LoggerFactory.getLogger(MessagesModuleLifecycle.class);

    /**
     * {@inheritDoc}
     */
    public void start(ModuleLifecycleContext ctx)
    {
        log.info("Starting module messages");
        ctx.registerModuleObservingComponent("locales", MessagesConfigurationManager.getInstance());
    }

    /**
     * {@inheritDoc}
     */
    public void stop(ModuleLifecycleContext ctx)
    {
        log.info("Stopping module messages");
    }

}
