package net.sourceforge.openutils.mgnlmessages.pages;

import info.magnolia.cms.util.ClasspathResourcesUtil;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;


/**
 * @author molaschi
 * @version $Id: DefaultMessagesImpl.java 4124 2008-09-22 14:56:46Z fgiust $
 */
public class DefaultMessagesImpl extends info.magnolia.cms.i18n.DefaultMessagesImpl
{

    /**
     * @param basename
     * @param locale
     */
    public DefaultMessagesImpl(String basename, Locale locale)
    {
        super(basename, locale);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String get(String key)
    {
        if (this.getBundle() == null)
        {
            return "??????";
        }
        return super.get(key);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected ResourceBundle getBundle()
    {
        if (bundle == null)
        {
            InputStream stream = null;
            try
            {
                if (StringUtils.isEmpty(getLocale().getCountry()))
                {
                    stream = ClasspathResourcesUtil.getStream("/"
                        + StringUtils.replace(basename, ".", "/")
                        + "_"
                        + getLocale().getLanguage()
                        + ".properties", false);
                }
                else
                {
                    stream = ClasspathResourcesUtil.getStream("/"
                        + StringUtils.replace(basename, ".", "/")
                        + "_"
                        + getLocale().getLanguage()
                        + "_"
                        + getLocale().getCountry()
                        + ".properties", false);
                }

                if (stream != null)
                {
                    bundle = new PropertyResourceBundle(stream);
                }
                else
                {
                    bundle = null;
                }
            }
            catch (IOException e)
            {
                log.error("can't load messages for " + basename);
            }
            finally
            {
                IOUtils.closeQuietly(stream);
            }
        }
        return bundle;
    }

}
