/**
 * Copyright Openmind http://www.openmindonline.it
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sourceforge.openutils.mgnlmessages.pages;

import info.magnolia.cms.beans.runtime.Document;
import info.magnolia.cms.i18n.Messages;
import info.magnolia.cms.i18n.MessagesChain;
import info.magnolia.cms.i18n.MessagesManager;
import info.magnolia.cms.util.AlertUtil;
import info.magnolia.context.MgnlContext;
import info.magnolia.module.admininterface.TemplatedMVCHandler;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.sourceforge.openutils.mgnlmessages.configuration.MessagesConfigurationManager;
import net.sourceforge.openutils.mgnlmessages.i18n.ModulePropertyMessagesImpl;
import net.sourceforge.openutils.mgnlmessages.i18n.RepositoryMessagesImpl;

import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * @author molaschi
 * @version $Id: MessagesImpExpPage.java 5694 2008-12-18 13:49:18Z manuel $
 */
public class MessagesImpExpPage extends TemplatedMVCHandler
{

    /**
     * Logger.
     */
    private Logger log = LoggerFactory.getLogger(MessagesImpExpPage.class);

    private Document uploadFile;

    /**
     * @param name
     * @param request
     * @param response
     */
    public MessagesImpExpPage(String name, HttpServletRequest request, HttpServletResponse response)
    {
        super(name, request, response);
    }

    /**
     * Export translations to an excel file
     * @return view
     */
    @SuppressWarnings("unchecked")
    public String exportExcel()
    {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet();
        HSSFRow row = sheet.createRow((short) 0);
        HSSFCell cell = row.createCell((short) 0);
        cell.setCellValue("KEY");

        int index = 1;
        List<Locale> locales = MessagesConfigurationManager.getAvaiableLocales();

        Map<Locale, Messages> messages = new HashMap<Locale, Messages>();
        for (Locale locale : locales)
        {
            cell = row.createCell((short) index);
            String localeCode = locale.getLanguage();
            if (!StringUtils.isEmpty(locale.getCountry()))
            {
                localeCode += "_" + locale.getCountry();
            }
            cell.setCellValue(localeCode);
            index++;

            Messages mc = new MessagesChain(new RepositoryMessagesImpl(MessagesManager.DEFAULT_BASENAME, locale))
                .chain(new ModulePropertyMessagesImpl(locale));

            for (String basename : MessagesConfigurationManager.getBaseNames())
            {
                ((MessagesChain) mc).chain(new DefaultMessagesImpl(basename, locale));
            }

            messages.put(locale, mc);
        }

        int r = 1;
        List<String> keys = new ArrayList<String>();
        Iterator it = MgnlContext.getMessages().keys();
        while (it.hasNext())
        {
            keys.add((String) it.next());
        }

        Collections.sort(keys);
        for (String key : keys)
        {
            short c = 0;
            row = sheet.createRow(r);
            cell = row.createCell(c);
            cell.setEncoding(HSSFWorkbook.ENCODING_UTF_16);
            cell.setCellValue(key);
            c++;
            for (Locale locale : locales)
            {

                String value = messages.get(locale).get(key);
                cell = row.createCell(c);
                if (!value.startsWith("???"))
                {
                    cell.setCellValue(value);
                }
                else
                {
                    cell.setCellValue("");
                }
                c++;
            }
            r++;
        }

        response.setContentType("application/vnd.ms-excel; name=\"messages.xls\"");
        response.addHeader("content-disposition", "attachment; filename=\"messages.xls\"");

        try
        {
            wb.write(response.getOutputStream());
        }
        catch (IOException e)
        {
            log.error("Exception writing excel to response", e);
            throw new RuntimeException(e);
        }

        return null;
    }

    /**
     * Import an excel file.
     * @return view name
     */
    public String importExcel()
    {
        FileInputStream fis;
        try
        {
            fis = new FileInputStream(uploadFile.getFile());
        }
        catch (FileNotFoundException e)
        {
            log.error("Error opening uploaded file", e);
            AlertUtil.setMessage("Error opening uploaded file, check that it is an Excel file", e);
            return this.show();
        }

        HSSFWorkbook wb;
        try
        {
            /*
             * File tmp = File.createTempFile("excel", ".xls"); FileOutputStream fos = new FileOutputStream(tmp);
             * IOUtils.copy(fis, fos); fis.close(); fos.close();
             */
            ByteArrayOutputStream byteOS = new ByteArrayOutputStream();
            IOUtils.copy(fis, byteOS);
            fis.close();
            byte[] allBytes = byteOS.toByteArray();

            // create workbook from array:
            InputStream byteIS = new ByteArrayInputStream(allBytes);
            wb = new HSSFWorkbook(byteIS);
            byteIS.close();
        }
        catch (IOException e)
        {
            log.error("Error opening uploaded file", e);
            AlertUtil.setMessage("Error opening uploaded file, check that it is an Excel file", e);
            return this.show();
        }
        HSSFSheet sh = wb.getSheetAt(0);
        HSSFRow row = sh.getRow(0);
        List<String> locales = new ArrayList<String>();
        for (short i = 2; i <= row.getLastCellNum(); i++)
        {
            HSSFCell cell = row.getCell((short) (i - 1));
            String locale = cell.getStringCellValue();
            if (StringUtils.isEmpty(locale))
            {
                break;
            }
            locales.add(locale);
        }

        for (int r = 1; r < sh.getLastRowNum(); r++)
        {
            row = sh.getRow(r);
            String key = row.getCell((short) 0).getStringCellValue();
            if (StringUtils.isEmpty(key))
            {
                break;
            }
            for (short c = 1; c < row.getLastCellNum(); c++)
            {
                if (row.getCell(c) == null)
                {
                    continue;
                }
                String value = row.getCell(c).getStringCellValue();
                if (!StringUtils.isEmpty(value))
                {
                    try
                    {
                        MessagesConfigurationManager.saveKeyValue(key, value, locales.get(c - 1));
                    }
                    catch (RepositoryException e)
                    {
                        log.error("Error saving key " + key + " on locale " + locales.get(c - 1), e);
                    }
                }
            }
        }

        return this.show();
    }

    /**
     * Returns the uploadFile.
     * @return the uploadFile
     */
    public Document getUploadFile()
    {
        return uploadFile;
    }

    /**
     * Sets the uploadFile.
     * @param uploadFile the uploadFile to set
     */
    public void setUploadFile(Document uploadFile)
    {
        this.uploadFile = uploadFile;
    }

    public Messages getMessages()
    {
        return MgnlContext.getMessages();
    }
}
