/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmessages.configuration;

import info.magnolia.cms.beans.config.ObservedManager;
import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.HierarchyManager;
import info.magnolia.cms.core.ItemType;
import info.magnolia.cms.core.NodeData;
import info.magnolia.cms.util.ContentUtil;
import info.magnolia.cms.util.FactoryUtil;
import info.magnolia.cms.util.NodeDataUtil;
import info.magnolia.context.MgnlContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessagesConfigurationManager
extends ObservedManager {
    public static final ItemType FOLDER = ItemType.CONTENT;
    private List<Locale> locales = new ArrayList<Locale>();
    public static final String MESSAGES_REPO = "messages";

    protected void onClear() {
        this.locales.clear();
    }

    protected void onRegister(Content node) {
        if (node.getNodeDataCollection() != null) {
            this.locales.clear();
            for (Content langNode : ContentUtil.getAllChildren((Content)node)) {
                this.locales.add(new Locale(NodeDataUtil.getString((Content)langNode, (String)"language"), NodeDataUtil.getString((Content)langNode, (String)"country")));
            }
            Collections.sort(this.locales, new Comparator<Locale>(){

                @Override
                public int compare(Locale o1, Locale o2) {
                    if (o1.getLanguage().equals(o2.getLanguage())) {
                        return o1.getCountry().compareTo(o2.getCountry());
                    }
                    return o1.getLanguage().compareTo(o2.getLanguage());
                }
            });
        }
    }

    public static MessagesConfigurationManager getInstance() {
        return (MessagesConfigurationManager)((Object)FactoryUtil.getSingleton(MessagesConfigurationManager.class));
    }

    public static List<Locale> getAvaiableLocales() {
        return MessagesConfigurationManager.getInstance().getLocales();
    }

    public static List<String> getBaseNames() {
        HierarchyManager mgr = MgnlContext.getSystemContext().getHierarchyManager("config");
        try {
            Content basenamesNode = mgr.getContent("/modules/messages/basenames");
            if (basenamesNode == null || !basenamesNode.hasChildren(ItemType.CONTENTNODE.getSystemName())) {
                return new ArrayList<String>();
            }
            ArrayList<String> basenames = new ArrayList<String>();
            for (Content bn : basenamesNode.getChildren(ItemType.CONTENTNODE.getSystemName())) {
                basenames.add(NodeDataUtil.getString((Content)bn, (String)"basename"));
            }
            return basenames;
        }
        catch (RepositoryException e) {
            return new ArrayList<String>();
        }
    }

    public static void saveKeyValue(String key, String value, String locale) throws RepositoryException {
        HierarchyManager mgr = MgnlContext.getSystemContext().getHierarchyManager(MESSAGES_REPO);
        String path = "/" + StringUtils.replace((String)key, (String)".", (String)"/");
        Content content = MessagesConfigurationManager.getOrCreateFullPath(mgr, path);
        if (!StringUtils.isEmpty((String)locale)) {
            NodeData nd = NodeDataUtil.getOrCreate((Content)content, (String)locale);
            if (!StringUtils.isEmpty((String)value)) {
                nd.setValue(value);
            } else {
                nd.delete();
            }
        }
        mgr.save();
    }

    private static Content getOrCreateFullPath(HierarchyManager mgr, String path) throws RepositoryException {
        try {
            return mgr.getContent(path);
        }
        catch (RepositoryException ex) {
            String parent = StringUtils.substringBeforeLast((String)path, (String)"/");
            String label = StringUtils.substringAfterLast((String)path, (String)"/");
            if (!StringUtils.isEmpty((String)parent)) {
                MessagesConfigurationManager.getOrCreateFullPath(mgr, parent);
            } else {
                parent = "/";
            }
            return mgr.createContent(parent, label, ItemType.CONTENTNODE.getSystemName());
        }
    }

    public List<Locale> getLocales() {
        return this.locales;
    }

    public void setLocales(List<Locale> locales) {
        this.locales = locales;
    }
}

