/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmessages.el;

import info.magnolia.cms.i18n.I18nContentSupportFactory;
import info.magnolia.cms.i18n.MessagesManager;
import info.magnolia.context.MgnlContext;
import info.magnolia.module.templating.MagnoliaTemplatingUtilities;
import java.text.MessageFormat;
import java.util.Locale;
import net.sourceforge.openutils.elfunctions.ElStringUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class MessagesEl {
    private static final String MSGS_TPL = "<span class=\"msgEdit {0}\" data-msgkey=\"{1}\" data-msglocale=\"{2}\" data-msgdefaultlocale=\"{3}\" data-msgdefault=\"{4}\">{5}</span>";

    public static String message(String key, boolean fallback, boolean defaultLocale, Object[] arguments) {
        if (defaultLocale) {
            return MessagesManager.getMessages((Locale)I18nContentSupportFactory.getI18nSupport().getFallbackLocale()).get(key, arguments);
        }
        String value = MessagesManager.getMessages((Locale)I18nContentSupportFactory.getI18nSupport().getLocale()).get(key, arguments);
        if (fallback && (StringUtils.isBlank((String)value) || StringUtils.startsWith((String)value, (String)"???"))) {
            return MessagesManager.getMessages((Locale)I18nContentSupportFactory.getI18nSupport().getFallbackLocale()).get(key, arguments);
        }
        return value;
    }

    public static String messageSimple(String key, Object[] arguments) {
        if (MgnlContext.getAggregationState().getMainContent() != null && MagnoliaTemplatingUtilities.getInstance().isEditMode() && MgnlContext.getAggregationState().getMainContent().isGranted(11L)) {
            String keyCssClass = StringUtils.replace((String)key, (String)".", (String)"_");
            String tag = MessageFormat.format(MSGS_TPL, keyCssClass, key, I18nContentSupportFactory.getI18nSupport().getLocale(), I18nContentSupportFactory.getI18nSupport().getFallbackLocale(), StringEscapeUtils.escapeHtml((String)MessagesEl.message(key, false, true)), MessagesEl.message(key, false, false));
            return tag;
        }
        return MessagesEl.message(key, true, false, arguments);
    }

    public static String messagePlain(String key, Object[] arguments) {
        return MessagesEl.message(key, true, false, arguments);
    }

    public static String messageSimple(String key) {
        return MessagesEl.messageSimple(key, null);
    }

    public static String message(String key, boolean fallback, boolean defaultLocale) {
        return MessagesEl.message(key, fallback, defaultLocale, null);
    }

    public static String messagePlain(String key) {
        return MessagesEl.messagePlain(key, null);
    }

    public static String messageSimple(String key, Object argument) {
        return MessagesEl.messageSimple(key, new Object[]{argument});
    }

    public static String message(String key, boolean fallback, boolean defaultLocale, Object argument) {
        return MessagesEl.message(key, fallback, defaultLocale, new Object[]{argument});
    }

    public static String messagePlain(String key, Object argument) {
        return MessagesEl.messagePlain(key, new Object[]{argument});
    }

    public static String messageSimple(String key, Object arg1, Object arg2) {
        return MessagesEl.messageSimple(key, new Object[]{arg1, arg2});
    }

    public static String message(String key, boolean fallback, boolean defaultLocale, Object arg1, Object arg2) {
        return MessagesEl.message(key, fallback, defaultLocale, new Object[]{arg1, arg2});
    }

    public static String messagePlain(String key, Object arg1, Object arg2) {
        return MessagesEl.messagePlain(key, new Object[]{arg1, arg2});
    }

    public static String messagePlain(String key, Object arg1, Object arg2, Object arg3) {
        return MessagesEl.messagePlain(key, new Object[]{arg1, arg2, arg3});
    }

    public static String escapeJs(String msg) {
        return StringEscapeUtils.escapeJavaScript((String)msg);
    }

    public static boolean messageTextContains(String str, String searchStr) {
        return StringUtils.containsIgnoreCase((String)ElStringUtils.stripHtmlTags((String)StringEscapeUtils.unescapeHtml((String)str)), (String)searchStr);
    }
}

