/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmessages.i18n;

import info.magnolia.cms.i18n.AbstractMessagesImpl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import net.sourceforge.openutils.mgnlmessages.configuration.MessagesConfigurationManager;
import net.sourceforge.openutils.mgnlmessages.i18n.OpenutilsMessagesImpl;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiBundleMessagesImpl
extends AbstractMessagesImpl {
    private List<OpenutilsMessagesImpl> messages = new ArrayList<OpenutilsMessagesImpl>();

    public MultiBundleMessagesImpl(Locale locale) {
        super(null, locale);
        for (String basename : MessagesConfigurationManager.getBaseNames()) {
            this.messages.add(new OpenutilsMessagesImpl(basename, locale));
        }
    }

    public String get(String key) {
        for (OpenutilsMessagesImpl message : this.messages) {
            String value = message.get(key);
            if (!StringUtils.isNotBlank((String)value) || StringUtils.startsWith((String)value, (String)"???")) continue;
            return value;
        }
        return "???" + key + "???";
    }

    public Iterator<String> keys() {
        HashSet keys = new HashSet();
        for (OpenutilsMessagesImpl message : this.messages) {
            try {
                keys.addAll(IteratorUtils.toList((Iterator)message.keys()));
            }
            catch (MissingResourceException ex) {}
        }
        return keys.iterator();
    }

    public void reload() throws Exception {
        for (OpenutilsMessagesImpl message : this.messages) {
            message.reload();
        }
    }
}

