/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmessages.i18n;

import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.HierarchyManager;
import info.magnolia.cms.i18n.AbstractMessagesImpl;
import info.magnolia.cms.util.NodeDataUtil;
import info.magnolia.cms.util.ObservationUtil;
import info.magnolia.context.MgnlContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import javax.jcr.RepositoryException;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.AdvancedResult;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.Criteria;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.JCRCriteriaFactory;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion.Criterion;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion.Order;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion.Restrictions;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryMessagesImpl
extends AbstractMessagesImpl {
    private List<String> keys;

    public RepositoryMessagesImpl(String basename, Locale locale) {
        super(basename, locale);
        ObservationUtil.registerChangeListener((String)"messages", (String)"/", (EventListener)new EventListener(){

            public void onEvent(EventIterator events) {
                RepositoryMessagesImpl.this.keys = null;
            }
        });
    }

    public String get(String key) {
        if (key == null) {
            return "??????";
        }
        try {
            String handle = StringUtils.replace((String)key, (String)".", (String)"/");
            HierarchyManager hm = MgnlContext.getSystemContext().getHierarchyManager("messages");
            Content c = hm.getContent(handle);
            String locale1 = this.locale.getLanguage() + "_" + this.locale.getCountry();
            String locale2 = this.locale.getLanguage();
            if (c == null || !c.hasNodeData(locale1) && !c.hasNodeData(locale2)) {
                return "???" + key + "???";
            }
            if (c.hasNodeData(locale1)) {
                return NodeDataUtil.getString((Content)c, (String)locale1);
            }
            return NodeDataUtil.getString((Content)c, (String)locale2);
        }
        catch (MissingResourceException e) {
            return "???" + key + "???";
        }
        catch (RepositoryException e) {
            return "???" + key + "???";
        }
    }

    public void reload() throws Exception {
        this.keys = null;
    }

    public Iterator<String> keys() {
        long ms = System.currentTimeMillis();
        if (this.keys == null) {
            this.keys = new ArrayList<String>();
            Criteria criteria = JCRCriteriaFactory.createCriteria().setWorkspace("messages").setBasePath("//*").add((Criterion)Restrictions.eq((String)"jcr:primaryType", (Object)"mgnl:contentNode")).addOrder(Order.desc((String)"@jcr:score"));
            AdvancedResult result = criteria.execute();
            this.log.debug("Number of messages loaded: {} with query {}", (Object)result.getTotalSize(), (Object)criteria.toXpathExpression());
            for (Content c : result.getItems()) {
                String key;
                if (c.getNodeDataCollection().size() <= 0 || !StringUtils.isNotEmpty((String)(key = StringUtils.substring((String)StringUtils.replace((String)c.getHandle(), (String)"/", (String)"."), (int)1)))) continue;
                this.keys.add(key);
            }
        }
        this.log.debug("Messages loaded in {} ms", (Object)(System.currentTimeMillis() - ms));
        return this.keys.iterator();
    }
}

