/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmessages.pages;

import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.HierarchyManager;
import info.magnolia.cms.core.ItemType;
import info.magnolia.cms.core.NodeData;
import info.magnolia.cms.core.search.Query;
import info.magnolia.cms.core.search.QueryManager;
import info.magnolia.cms.core.search.QueryResult;
import info.magnolia.cms.util.ContentUtil;
import info.magnolia.cms.util.NodeDataUtil;
import info.magnolia.context.MgnlContext;
import info.magnolia.module.admininterface.TemplatedMVCHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractMessagesFromDialogsPage
extends TemplatedMVCHandler {
    private List<String> dialogsRoot;
    private Logger log = LoggerFactory.getLogger(ExtractMessagesFromDialogsPage.class);

    public ExtractMessagesFromDialogsPage(String name, HttpServletRequest request, HttpServletResponse response) {
        super(name, request, response);
    }

    public String show() {
        this.dialogsRoot = new ArrayList<String>();
        QueryManager qm = MgnlContext.getQueryManager((String)"config");
        try {
            Query q = qm.createQuery("//dialogs", "xpath");
            QueryResult qr = q.execute();
            Collection dialogs = qr.getContent();
            for (Content dialog : dialogs) {
                this.dialogsRoot.add(dialog.getHandle());
            }
            q = qm.createQuery("//paragraphs", "xpath");
            qr = q.execute();
            dialogs = qr.getContent();
            for (Content dialog : dialogs) {
                this.dialogsRoot.add(dialog.getHandle());
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return super.show();
    }

    public String extract() {
        HierarchyManager hmConfig = MgnlContext.getHierarchyManager((String)"config");
        QueryManager qm = hmConfig.getQueryManager();
        HierarchyManager hm = MgnlContext.getHierarchyManager((String)"messages");
        for (String dialogRoot : this.request.getParameterValues("dialogsRoots")) {
            try {
                this.doExtraction(dialogRoot, "label", qm, hm, hmConfig);
            }
            catch (RepositoryException e) {
                this.log.error("Error extracting labels from dialogs and paragraphs", (Throwable)e);
            }
            try {
                this.doExtraction(dialogRoot, "description", qm, hm, hmConfig);
            }
            catch (RepositoryException e) {
                this.log.error("Error extracting description from dialogs and paragraphs", (Throwable)e);
            }
            try {
                this.doExtraction(dialogRoot, "title", qm, hm, hmConfig);
            }
            catch (RepositoryException e) {
                this.log.error("Error extracting description from dialogs and paragraphs", (Throwable)e);
            }
        }
        return this.show();
    }

    private void doExtraction(String root, String property, QueryManager qm, HierarchyManager hmMessages, HierarchyManager hmConfig) throws RepositoryException {
        Query q = qm.createQuery(root.substring(1) + "//*[@" + property + "]", "xpath");
        QueryResult qr = q.execute();
        ArrayList labelParents = new ArrayList();
        labelParents.addAll(qr.getContent(ItemType.CONTENTNODE.getSystemName()));
        labelParents.addAll(qr.getContent(ItemType.CONTENT.getSystemName()));
        for (Content labelParent : labelParents) {
            NodeData labelNd = labelParent.getNodeData(property);
            String label = labelNd.getString();
            if (StringUtils.isEmpty((String)label) || !MgnlContext.getMessages().get(label).startsWith("???")) continue;
            String parentPath = labelParent.getHandle();
            parentPath = StringUtils.replace((String)parentPath, (String)"/modules", (String)"");
            Content parent = this.getOrCreateFullPath(hmMessages, parentPath);
            Content message = ContentUtil.getOrCreateContent((Content)parent, (String)property, (ItemType)ItemType.CONTENTNODE);
            NodeData nd = NodeDataUtil.getOrCreate((Content)message, (String)"en");
            nd.setValue(label);
            nd = NodeDataUtil.getOrCreate((Content)message, (String)"it");
            nd.setValue(label);
            String messageKey = message.getHandle().substring(1);
            messageKey = StringUtils.replace((String)messageKey, (String)"/", (String)".");
            labelNd.setValue(messageKey);
        }
        hmMessages.save();
        hmConfig.save();
    }

    private Content getOrCreateFullPath(HierarchyManager mgr, String path) throws RepositoryException {
        try {
            return mgr.getContent(path);
        }
        catch (RepositoryException ex) {
            String parent = StringUtils.substringBeforeLast((String)path, (String)"/");
            String label = StringUtils.substringAfterLast((String)path, (String)"/");
            if (!StringUtils.isEmpty((String)parent)) {
                this.getOrCreateFullPath(mgr, parent);
            } else {
                parent = "/";
            }
            Content c = mgr.createContent(parent, label, ItemType.CONTENTNODE.getSystemName());
            mgr.save();
            return c;
        }
    }

    public List<String> getDialogsRoot() {
        return this.dialogsRoot;
    }

    public void setDialogsRoot(List<String> dialogsRoot) {
        this.dialogsRoot = dialogsRoot;
    }
}

