/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmessages.pages;

import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.HierarchyManager;
import info.magnolia.cms.core.ItemType;
import info.magnolia.cms.core.Path;
import info.magnolia.cms.i18n.Messages;
import info.magnolia.context.MgnlContext;
import info.magnolia.module.admininterface.TemplatedMVCHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.openutils.mgnlmessages.configuration.MessagesConfigurationManager;
import net.sourceforge.openutils.mgnlmessages.el.MessagesEl;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessagesEditPage
extends TemplatedMVCHandler {
    private static final String JSON_VIEW = "js";
    private Logger log = LoggerFactory.getLogger(MessagesEditPage.class);
    private List<String> keys;
    private List<Locale> locales;
    private String currentLanguage;
    private String json;
    private String key;
    private String locale;
    private String text;
    private String newkey;

    public MessagesEditPage(String name, HttpServletRequest request, HttpServletResponse response) {
        super(name, request, response);
    }

    public void init() {
        super.init();
    }

    public void renderHtml(String view) throws IOException {
        if (JSON_VIEW.equals(view)) {
            this.response.setContentType("text/json");
            this.response.getWriter().write(this.json);
        } else {
            this.keys = new ArrayList<String>();
            Iterator it = MgnlContext.getMessages().keys();
            while (it.hasNext()) {
                this.keys.add((String)it.next());
            }
            Collections.sort(this.keys);
            this.locales = MessagesConfigurationManager.getAvaiableLocales();
            Locale loc = this.request.getLocale();
            if (this.locales != null && !this.locales.isEmpty() && !this.locales.contains(loc)) {
                loc = this.locales.get(0);
            }
            this.currentLanguage = loc.getLanguage();
            if (loc.getCountry() != null && loc.getCountry().length() > 0) {
                this.currentLanguage = this.currentLanguage + "_" + loc.getCountry();
            }
            super.renderHtml(view);
        }
    }

    public String loadkey() {
        Locale locBk = MgnlContext.getLocale();
        Locale newLoc = null;
        newLoc = this.locale.indexOf(95) > 0 ? new Locale(StringUtils.substringBefore((String)this.locale, (String)"_"), StringUtils.substringAfter((String)this.locale, (String)"_")) : new Locale(this.locale);
        MgnlContext.setLocale((Locale)newLoc);
        this.json = "rootObj = {value: '" + StringUtils.defaultString((String)StringUtils.replaceEach((String)MgnlContext.getMessages().get(this.key), (String[])new String[]{"'", "\n"}, (String[])new String[]{"\\'", "\\n"})) + "'}";
        MgnlContext.setLocale((Locale)locBk);
        return JSON_VIEW;
    }

    public String savekey() {
        try {
            MessagesConfigurationManager.saveKeyValue(this.key, this.text, this.locale);
            this.json = "rootObj = {value: 'OK'}";
        }
        catch (RepositoryException e) {
            this.log.error("Error saving key", (Throwable)e);
            this.json = "rootObj = {value: 'KO'}";
        }
        return JSON_VIEW;
    }

    public String removekey() {
        try {
            HierarchyManager mgr = MgnlContext.getSystemContext().getHierarchyManager("messages");
            String path = "/" + StringUtils.replace((String)this.key, (String)".", (String)"/");
            mgr.delete(path);
            mgr.save();
            String parent = StringUtils.substringBeforeLast((String)path, (String)"/");
            if (!StringUtils.isEmpty((String)parent) && !mgr.getContent(parent).hasChildren(ItemType.CONTENTNODE.getSystemName())) {
                this.key = StringUtils.replace((String)parent.substring(1), (String)"/", (String)".");
                this.removekey();
            }
            this.json = "rootObj = {value: 'OK'}";
        }
        catch (PathNotFoundException e) {
            this.json = "rootObj = {value: 'NOTFOUND'}";
        }
        catch (RepositoryException e) {
            this.log.error("Error removing key", (Throwable)e);
            this.json = "rootObj = {value: 'KO'}";
        }
        return JSON_VIEW;
    }

    public String renamekey() {
        try {
            this.moveNode("/" + StringUtils.replace((String)this.key, (String)".", (String)"/"), "/" + StringUtils.replace((String)this.newkey, (String)".", (String)"/"));
            this.json = "rootObj = {value: 'OK'}";
        }
        catch (RepositoryException e) {
            this.log.error("Error removing key", (Throwable)e);
            this.json = "rootObj = {value: 'KO'}";
        }
        return JSON_VIEW;
    }

    public String search() {
        HashSet<String> keySet = new HashSet<String>();
        if (!StringUtils.isBlank((String)this.text)) {
            Locale locBk = MgnlContext.getLocale();
            for (Locale newLoc : MessagesConfigurationManager.getAvaiableLocales()) {
                MgnlContext.setLocale((Locale)newLoc);
                Messages messages = MgnlContext.getMessages();
                Iterator it = messages.keys();
                while (it.hasNext()) {
                    String curKey = (String)it.next();
                    String curText = messages.get(curKey);
                    if (!MessagesEl.messageTextContains(curText, this.text)) continue;
                    keySet.add(curKey);
                }
            }
            MgnlContext.setLocale((Locale)locBk);
        }
        this.keys = new ArrayList<String>(keySet);
        Collections.sort(this.keys);
        StringBuilder sb = new StringBuilder("[ ");
        int i = 0;
        for (String curKey : this.keys) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("{ id: '").append(i++).append("', key: '").append(curKey).append("' }");
        }
        sb.append(" ]");
        this.json = sb.toString();
        return JSON_VIEW;
    }

    protected void moveNode(String source, String destination) throws RepositoryException {
        HierarchyManager hm;
        block6: {
            hm = MgnlContext.getSystemContext().getHierarchyManager("messages");
            String goTo = destination;
            if (hm.isExist(destination)) {
                String parentPath = StringUtils.substringBeforeLast((String)destination, (String)"/");
                String label = StringUtils.substringAfterLast((String)destination, (String)"/");
                label = Path.getUniqueLabel((HierarchyManager)hm, (String)parentPath, (String)label);
                goTo = parentPath + "/" + label;
            }
            if (destination.indexOf(source + "/") == 0) {
                return;
            }
            try {
                hm.moveTo(source, goTo);
            }
            catch (Exception e) {
                return;
            }
            Content newContent = hm.getContent(destination);
            try {
                newContent.updateMetaData();
                newContent.getMetaData().setUnActivated();
            }
            catch (RepositoryException e) {
                if (!this.log.isDebugEnabled()) break block6;
                this.log.debug("Exception caught: " + e.getMessage(), (Throwable)e);
            }
        }
        hm.save();
    }

    public List<String> getKeys() {
        return this.keys;
    }

    public void setKeys(List<String> keys) {
        this.keys = keys;
    }

    public List<Locale> getLocales() {
        return this.locales;
    }

    public void setLocales(List<Locale> locales) {
        this.locales = locales;
    }

    public String getCurrentLanguage() {
        return this.currentLanguage;
    }

    public void setCurrentLanguage(String currentLanguage) {
        this.currentLanguage = currentLanguage;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getNewkey() {
        return this.newkey;
    }

    public void setNewkey(String newkey) {
        this.newkey = newkey;
    }
}

