/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmessages.pages;

import info.magnolia.cms.beans.runtime.Document;
import info.magnolia.cms.i18n.Messages;
import info.magnolia.cms.util.AlertUtil;
import info.magnolia.module.admininterface.TemplatedMVCHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.openutils.mgnlmessages.configuration.MessagesConfigurationManager;
import net.sourceforge.openutils.mgnlmessages.pages.NoDefaultBundlesMessagesImpl;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagesImpExpPage
extends TemplatedMVCHandler {
    private Logger log = LoggerFactory.getLogger(MessagesImpExpPage.class);
    private Document uploadFile;

    public MessagesImpExpPage(String name, HttpServletRequest request, HttpServletResponse response) {
        super(name, request, response);
    }

    public String exportExcel() {
        HSSFWorkbook wb = new HSSFWorkbook();
        HashMap messages = new HashMap();
        List<Locale> locales = MessagesConfigurationManager.getAvaiableLocales();
        for (String basename : MessagesConfigurationManager.getBaseNames()) {
            LinkedHashSet<NoDefaultBundlesMessagesImpl> msgs = new LinkedHashSet<NoDefaultBundlesMessagesImpl>();
            for (Locale locale : locales) {
                this.log.debug("Adding locale {}", (Object)locale);
                NoDefaultBundlesMessagesImpl bundle = new NoDefaultBundlesMessagesImpl(basename, locale);
                msgs.add(bundle);
                bundle.get("");
            }
            messages.put(basename, msgs);
        }
        HSSFCellStyle style = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setBoldweight((short)700);
        style.setFont(font);
        for (String basename : messages.keySet()) {
            HSSFSheet sheet;
            String sheetname = StringUtils.replace((String)basename, (String)"info.magnolia.module.", (String)"i.m.m.");
            try {
                sheet = wb.createSheet(sheetname);
            }
            catch (IllegalArgumentException e) {
                this.log.warn("Duplicated basename found, skipping: \"{}\"", (Object)basename);
                continue;
            }
            HSSFRow header = sheet.createRow(0);
            HSSFCell headerCell = header.createCell(0);
            headerCell.setCellStyle(style);
            headerCell.setCellValue("KEY");
            Set msgs = (Set)messages.get(basename);
            this.log.debug("Processing {} with {} locales", (Object)basename, (Object)msgs.size());
            TreeSet keys = new TreeSet();
            for (Messages smessage : msgs) {
                this.log.debug("Extracting keys from locale {}", (Object)smessage.getLocale());
                Iterator it = smessage.keys();
                while (it.hasNext()) {
                    keys.add(it.next());
                }
            }
            this.log.debug("Bundle {} has {} keys", (Object)basename, (Object)keys.size());
            int r = 1;
            for (String key : keys) {
                int c = 0;
                HSSFRow row = sheet.createRow(r);
                HSSFCell cell = row.createCell(c);
                cell = row.createCell(c++);
                cell.setCellValue(key);
                for (Messages entry : msgs) {
                    header = sheet.getRow(0);
                    headerCell = header.createCell(c);
                    headerCell.setCellStyle(style);
                    Locale locale = entry.getLocale();
                    String localeCode = locale.getLanguage();
                    if (!StringUtils.isEmpty((String)locale.getCountry())) {
                        localeCode = localeCode + "_" + locale.getCountry();
                    }
                    headerCell.setCellValue(localeCode);
                    String value = entry.get(key);
                    cell = row.createCell(c);
                    if (value != null) {
                        cell.setCellValue(value);
                    }
                    ++c;
                }
                ++r;
            }
        }
        this.response.setContentType("application/vnd.ms-excel; name=\"messages.xls\"");
        this.response.addHeader("content-disposition", "attachment; filename=\"messages.xls\"");
        try {
            wb.write((OutputStream)this.response.getOutputStream());
        }
        catch (IOException e) {
            this.log.error("Exception writing excel to response", (Throwable)e);
            throw new RuntimeException(e);
        }
        return null;
    }

    public String importExcel() {
        HSSFWorkbook wb;
        FileInputStream fis;
        if (this.uploadFile == null) {
            AlertUtil.setMessage((String)"Please select an excel file for upload");
            return this.show();
        }
        try {
            fis = new FileInputStream(this.uploadFile.getFile());
        }
        catch (FileNotFoundException e) {
            this.log.error("Error opening uploaded file", (Throwable)e);
            AlertUtil.setMessage((String)"Error opening uploaded file, check that it is an Excel file", (Exception)e);
            return this.show();
        }
        try {
            ByteArrayOutputStream byteOS = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)fis, (OutputStream)byteOS);
            fis.close();
            byte[] allBytes = byteOS.toByteArray();
            ByteArrayInputStream byteIS = new ByteArrayInputStream(allBytes);
            wb = new HSSFWorkbook((InputStream)byteIS);
            ((InputStream)byteIS).close();
        }
        catch (IOException e) {
            this.log.error("Error opening uploaded file", (Throwable)e);
            AlertUtil.setMessage((String)"Error opening uploaded file, check that it is an Excel file", (Exception)e);
            return this.show();
        }
        for (int k = 0; k < wb.getNumberOfSheets(); ++k) {
            String key;
            HSSFCell cell;
            String locale;
            HSSFSheet sh = wb.getSheetAt(k);
            HSSFRow row = sh.getRow(0);
            ArrayList<String> locales = new ArrayList<String>();
            for (short i = 2; i <= row.getLastCellNum() && !StringUtils.isEmpty((String)(locale = (cell = row.getCell(i - 1)).getStringCellValue())); i = (short)(i + 1)) {
                locales.add(locale);
            }
            for (int r = 1; r < sh.getLastRowNum() && !StringUtils.isEmpty((String)(key = (row = sh.getRow(r)).getCell(0).getStringCellValue())); ++r) {
                for (int c = 1; c < row.getLastCellNum(); ++c) {
                    String value;
                    if (row.getCell(c) == null || StringUtils.isEmpty((String)(value = row.getCell(c).getStringCellValue()))) continue;
                    try {
                        MessagesConfigurationManager.saveKeyValue(key, value, (String)locales.get(c - 1));
                        continue;
                    }
                    catch (RepositoryException e) {
                        this.log.error("Error saving key " + key + " on locale " + (String)locales.get(c - 1), (Throwable)e);
                    }
                }
            }
        }
        AlertUtil.setMessage((String)"Translations successfully loaded");
        return this.show();
    }

    public Document getUploadFile() {
        return this.uploadFile;
    }

    public void setUploadFile(Document uploadFile) {
        this.uploadFile = uploadFile;
    }

    public Messages getMsgs() {
        return super.getMsgs();
    }
}

