/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmessages.pages;

import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.HierarchyManager;
import info.magnolia.cms.i18n.DefaultMessagesImpl;
import info.magnolia.cms.util.ClasspathResourcesUtil;
import info.magnolia.cms.util.NodeDataUtil;
import info.magnolia.context.MgnlContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.jcr.RepositoryException;
import net.sourceforge.openutils.mgnlmessages.i18n.EmptyResourceBundle;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.slf4j.LoggerFactory;

public class NoDefaultBundlesMessagesImpl
extends DefaultMessagesImpl {
    public NoDefaultBundlesMessagesImpl(String basename, Locale locale) {
        super(basename, locale);
        this.log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        this.log.debug("initializing bundle {}", (Object)basename);
    }

    public String get(String key) {
        if (this.getBundle() == null) {
            return null;
        }
        String value = this.getFromRepository(key);
        if (value == null) {
            try {
                value = this.getBundle().getString(key);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return value;
    }

    private String getFromRepository(String key) {
        try {
            String handle = StringUtils.replace((String)key, (String)".", (String)"/");
            HierarchyManager hm = MgnlContext.getSystemContext().getHierarchyManager("messages");
            Content c = hm.getContent(handle);
            String locale1 = this.locale.getLanguage() + (StringUtils.isEmpty((String)this.locale.getCountry()) ? "" : "_" + this.locale.getCountry());
            if (c != null && c.hasNodeData(locale1)) {
                return NodeDataUtil.getString((Content)c, (String)locale1);
            }
        }
        catch (MissingResourceException e) {
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResourceBundle getBundle() {
        if (this.bundle == null) {
            InputStream stream = null;
            try {
                String file = "/" + StringUtils.replace((String)this.basename, (String)".", (String)"/") + "_" + this.getLocale().getLanguage() + (StringUtils.isEmpty((String)this.getLocale().getCountry()) ? "" : "_" + this.getLocale().getCountry()) + ".properties";
                this.log.debug("loading bundle {}", (Object)file);
                stream = ClasspathResourcesUtil.getStream((String)file, (boolean)false);
                this.bundle = stream != null ? new PropertyResourceBundle(stream) : new EmptyResourceBundle();
                IOUtils.closeQuietly((InputStream)stream);
            }
            catch (IOException e) {
                this.log.error("can't load messages for " + this.basename);
            }
            finally {
                IOUtils.closeQuietly(stream);
            }
        }
        return this.bundle;
    }

    public boolean equals(Object object) {
        if (!(object instanceof NoDefaultBundlesMessagesImpl)) {
            return false;
        }
        NoDefaultBundlesMessagesImpl rhs = (NoDefaultBundlesMessagesImpl)((Object)object);
        return new EqualsBuilder().append((Object)this.basename, (Object)rhs.basename).append((Object)this.locale, (Object)rhs.locale).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(-399088031, -1971683455).append((Object)this.basename).append((Object)this.locale).toHashCode();
    }
}

