/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.usermanagement.dataobjects;

import it.openutils.usermanagement.dataobjects.Group;
import it.openutils.usermanagement.dataobjects.Role;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.userdetails.UserDetails;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="APP_USER")
public class User
implements Serializable,
UserDetails {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="ID_USER", length=50)
    private String id;
    @Column(name="PASSWORD", nullable=false, length=50)
    private String password;
    @Column(name="ENABLED", nullable=false)
    private Boolean enabled;
    @Column(name="NAME", nullable=false, length=80)
    private String name;
    @Column(name="SURNAME", nullable=false, length=80)
    private String surname;
    @Column(name="EMAIL", nullable=false, length=150)
    private String email;
    @ManyToMany(cascade={CascadeType.PERSIST}, targetEntity=Group.class, fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SUBSELECT)
    @JoinTable(name="APP_USER_GROUP", joinColumns={@JoinColumn(name="ID_USER")}, inverseJoinColumns={@JoinColumn(name="ID_GROUP")})
    private Set<Group> groups;

    public Set<Group> getGroups() {
        return this.groups;
    }

    public void setGroups(Set<Group> groups) {
        this.groups = groups;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Set<Role> getRoles() {
        if (this.groups == null) {
            return null;
        }
        HashSet<Role> roles = new HashSet<Role>();
        for (Group group : this.groups) {
            roles.addAll(group.getRoles());
        }
        return roles;
    }

    public boolean isAccountNonExpired() {
        return this.enabled == null ? false : this.enabled;
    }

    public boolean isAccountNonLocked() {
        return this.enabled == null ? false : this.enabled;
    }

    public boolean isCredentialsNonExpired() {
        return this.enabled == null ? false : this.enabled;
    }

    public GrantedAuthority[] getAuthorities() {
        if (this.getRoles() == null) {
            return null;
        }
        GrantedAuthorityImpl[] auths = new GrantedAuthorityImpl[this.getRoles().size()];
        Iterator<Role> iter = this.getRoles().iterator();
        int i = 0;
        while (iter.hasNext()) {
            Role r = iter.next();
            auths[i] = new GrantedAuthorityImpl(r.getId());
            ++i;
        }
        return auths;
    }

    public String getUsername() {
        return this.id;
    }

    public boolean isEnabled() {
        return this.enabled == null ? false : this.enabled;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSurname() {
        return this.surname;
    }

    public void setSurname(String surname) {
        this.surname = surname;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("id", (Object)this.id).append("enabled", (Object)this.enabled).append("name", (Object)this.name).append("surname", (Object)this.surname).append("authorities", (Object[])this.getAuthorities()).append("username", (Object)this.getUsername()).append("email", (Object)this.email).append("password", (Object)this.password).toString();
    }
}

