/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.usermanagement.manager;

import it.openutils.usermanagement.dao.UserDAO;
import it.openutils.usermanagement.dataobjects.User;
import it.openutils.usermanagement.manager.UserManager;
import java.io.Serializable;
import org.acegisecurity.providers.encoding.ShaPasswordEncoder;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserManagerImpl
implements UserManager {
    private UserDAO userDAO;
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private ShaPasswordEncoder passwordEncoder;

    public void setPasswordEncoder(ShaPasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    public void setUserDAO(UserDAO userDAO) {
        this.userDAO = userDAO;
    }

    public String resetPassword(String userid) {
        User resetUser = (User)this.userDAO.load((Serializable)((Object)userid));
        String plainPassword = StringUtils.upperCase((String)RandomStringUtils.randomAlphanumeric((int)6));
        String passwordHash = this.passwordEncoder.encodePassword(plainPassword, null);
        resetUser.setPassword(passwordHash);
        this.userDAO.update(resetUser);
        return plainPassword;
    }

    public boolean changePassword(String userid, String oldPassword, String newPassword) {
        User user;
        String oldPasswordHash = this.passwordEncoder.encodePassword(oldPassword, null);
        if (oldPasswordHash.equals((user = (User)this.userDAO.load((Serializable)((Object)userid))).getPassword())) {
            String newPasswordHash = this.passwordEncoder.encodePassword(newPassword, null);
            user.setPassword(newPasswordHash);
            this.userDAO.save(user);
            return true;
        }
        return false;
    }
}

