/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.change;

import java.util.Collection;
import org.semanticweb.owlapi.change.AbstractCompositeOntologyChange;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class CreateValuePartition
extends AbstractCompositeOntologyChange {
    public CreateValuePartition(OWLDataFactory dataFactory, OWLClass valuePartitionClass, Collection<OWLClass> valuePartionClasses, OWLObjectProperty valuePartitionProperty, OWLOntology targetOntology) {
        super(dataFactory);
        this.generateChanges(OWLAPIPreconditions.checkNotNull(targetOntology, "targetOntology cannot be null"), OWLAPIPreconditions.checkNotNull(valuePartionClasses, "valuePartionClasses cannot be null"), OWLAPIPreconditions.checkNotNull(valuePartitionClass, "valuePartitionClass cannot be null"), OWLAPIPreconditions.checkNotNull(valuePartitionProperty, "valuePartitionProperty cannot be null"));
    }

    private void generateChanges(OWLOntology targetOntology, Collection<OWLClass> valuePartitionClasses, OWLClass valuePartitionClass, OWLObjectProperty valuePartitionProperty) {
        for (OWLClassExpression oWLClassExpression : valuePartitionClasses) {
            this.addChange(new AddAxiom(targetOntology, this.df.getOWLSubClassOfAxiom(oWLClassExpression, valuePartitionClass)));
        }
        this.addChange(new AddAxiom(targetOntology, this.df.getOWLDisjointClassesAxiom(valuePartitionClasses)));
        OWLObjectUnionOf oWLObjectUnionOf = this.df.getOWLObjectUnionOf(valuePartitionClasses);
        this.addChange(new AddAxiom(targetOntology, this.df.getOWLSubClassOfAxiom(valuePartitionClass, oWLObjectUnionOf)));
        this.addChange(new AddAxiom(targetOntology, this.df.getOWLFunctionalObjectPropertyAxiom(valuePartitionProperty)));
        this.addChange(new AddAxiom(targetOntology, this.df.getOWLObjectPropertyRangeAxiom(valuePartitionProperty, valuePartitionClass)));
    }
}

