/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Optional;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSourceBase;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDocumentSource
extends OWLOntologyDocumentSourceBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileDocumentSource.class);
    private final File file;

    public FileDocumentSource(File file) {
        this(file, null, null);
    }

    public FileDocumentSource(File file, OWLDocumentFormat format) {
        this(file, format, null);
    }

    public FileDocumentSource(File file, @Nullable OWLDocumentFormat format, @Nullable String mime) {
        super(IRI.create(file), format, mime);
        this.file = OWLAPIPreconditions.checkNotNull(file, "file cannot be null");
    }

    @Override
    public Optional<InputStream> getInputStream() {
        try {
            return OWLAPIPreconditions.optional(new FileInputStream(this.file));
        }
        catch (FileNotFoundException e) {
            LOGGER.error("File cannot be found", (Throwable)e);
            this.failedOnStreams.set(true);
            return OWLAPIPreconditions.emptyOptional();
        }
    }
}

