/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLObject;
import org.semanticweb.owlapi.model.SWRLObjectVisitor;
import org.semanticweb.owlapi.model.SWRLObjectVisitorEx;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public interface SWRLRule
extends OWLLogicalAxiom,
SWRLObject {
    @Override
    default public Stream<?> components() {
        return Stream.of(this.bodyList(), this.headList(), this.annotationsAsList());
    }

    @Override
    default public int initHashCode() {
        int hash = this.hashIndex();
        hash = OWLObject.hashIteration(hash, this.bodyList().hashCode());
        hash = OWLObject.hashIteration(hash, this.headList().hashCode());
        return OWLObject.hashIteration(hash, this.annotationsAsList().hashCode());
    }

    @Override
    default public Stream<?> componentsWithoutAnnotations() {
        return Stream.of(this.bodyList(), this.headList());
    }

    @Override
    default public Stream<?> componentsAnnotationsFirst() {
        return Stream.of(this.annotationsAsList(), this.bodyList(), this.headList());
    }

    @Override
    default public int hashIndex() {
        return 631;
    }

    @Deprecated
    default public Set<SWRLAtom> getBody() {
        return OWLAPIStreamUtils.asSet(this.body());
    }

    default public List<SWRLAtom> bodyList() {
        return OWLAPIStreamUtils.asList(this.body());
    }

    default public List<SWRLAtom> headList() {
        return OWLAPIStreamUtils.asList(this.head());
    }

    public Stream<SWRLAtom> body();

    @Deprecated
    default public Set<SWRLAtom> getHead() {
        return OWLAPIStreamUtils.asSet(this.head());
    }

    public Stream<SWRLAtom> head();

    public SWRLRule getSimplified();

    @Deprecated
    default public Set<SWRLVariable> getVariables() {
        return OWLAPIStreamUtils.asSet(this.variables());
    }

    public Stream<SWRLVariable> variables();

    public boolean containsAnonymousClassExpressions();

    @Deprecated
    default public Set<OWLClassExpression> getClassAtomPredicates() {
        return OWLAPIStreamUtils.asSet(this.classAtomPredicates());
    }

    public Stream<OWLClassExpression> classAtomPredicates();

    public SWRLRule getAxiomWithoutAnnotations();

    @Override
    default public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    default public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    default public void accept(SWRLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    default public <O> O accept(SWRLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    default public void accept(OWLAxiomVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    default public <O> O accept(OWLAxiomVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    default public AxiomType<?> getAxiomType() {
        return AxiomType.SWRL_RULE;
    }
}

