/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.profiles;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.semanticweb.owlapi.profiles.OWLProfile;
import org.semanticweb.owlapi.profiles.OWLProfileViolation;

public class OWLProfileReport {
    private final OWLProfile profile;
    private final List<OWLProfileViolation> violations;

    public OWLProfileReport(OWLProfile profile, Collection<OWLProfileViolation> violations) {
        this.profile = profile;
        this.violations = new ArrayList<OWLProfileViolation>(violations);
    }

    public OWLProfile getProfile() {
        return this.profile;
    }

    public boolean isInProfile() {
        return this.violations.isEmpty();
    }

    public List<OWLProfileViolation> getViolations() {
        return this.violations;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.profile.getName());
        sb.append(" Profile Report: ");
        if (this.isInProfile()) {
            sb.append("[Ontology and imports closure in profile]\n");
        } else {
            sb.append("Ontology and imports closure NOT in profile. The following violations are present:\n");
        }
        this.violations.forEach(v -> {
            StringBuilder stringBuilder2 = sb.append(v).append('\n');
        });
        return sb.toString();
    }
}

