/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public class ImportsStructureObjectSorter<O> {
    private final OWLOntology ontology;
    private final ObjectSelector<O> objectSelector;

    public ImportsStructureObjectSorter(OWLOntology ontology, ObjectSelector<O> objectSelector) {
        this.ontology = OWLAPIPreconditions.checkNotNull(ontology, "ontology cannot be null");
        this.objectSelector = OWLAPIPreconditions.checkNotNull(objectSelector, "objectSelector cannot be null");
    }

    public Map<OWLOntology, Set<O>> getObjects() {
        List<OWLOntology> imports = OWLAPIStreamUtils.asList(this.ontology.importsClosure());
        Collections.reverse(imports);
        HashMap<OWLOntology, Set<O>> ontology2EntityMap = new HashMap<OWLOntology, Set<O>>();
        HashSet processed = new HashSet();
        imports.forEach(ont -> {
            Set<Object> set2 = ontology2EntityMap.put((OWLOntology)ont, (Set<O>)OWLAPIStreamUtils.asSet(this.objectSelector.objects((OWLOntology)ont).filter(processed::add)));
        });
        return ontology2EntityMap;
    }

    @FunctionalInterface
    public static interface ObjectSelector<O> {
        public Stream<O> objects(OWLOntology var1);
    }
}

