/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.stream.Stream;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataRangeVisitorEx;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public class NNF
implements OWLAxiomVisitorEx<OWLAxiom> {
    protected final OWLDataFactory df;
    protected final OWLClassExpressionVisitorEx<OWLClassExpression> classVisitor = new ClassVisitor();
    protected final OWLDataRangeVisitorEx<OWLDataRange> dataVisitor = new DataVisitor();
    protected boolean negated;

    public NNF(OWLDataFactory datafactory) {
        this.df = OWLAPIPreconditions.checkNotNull(datafactory, "dataFactory cannot be null");
    }

    public OWLClassExpressionVisitorEx<OWLClassExpression> getClassVisitor() {
        return this.classVisitor;
    }

    public void reset() {
        this.negated = false;
    }

    @Override
    public <T> OWLAxiom doDefault(T object) {
        return (OWLAxiom)object;
    }

    @Override
    public OWLAxiom visit(OWLSubClassOfAxiom axiom) {
        return this.df.getOWLSubClassOfAxiom(axiom.getSubClass().accept(this.classVisitor), axiom.getSuperClass().accept(this.classVisitor));
    }

    @Override
    public OWLAxiom visit(OWLDisjointClassesAxiom axiom) {
        return this.df.getOWLDisjointClassesAxiom(axiom.classExpressions().map(p -> p.accept(this.classVisitor)));
    }

    @Override
    public OWLAxiom visit(OWLDataPropertyDomainAxiom axiom) {
        return this.df.getOWLDataPropertyDomainAxiom((OWLDataPropertyExpression)axiom.getProperty(), ((OWLClassExpression)axiom.getDomain()).accept(this.classVisitor));
    }

    @Override
    public OWLAxiom visit(OWLObjectPropertyDomainAxiom axiom) {
        return this.df.getOWLObjectPropertyDomainAxiom((OWLObjectPropertyExpression)axiom.getProperty(), ((OWLClassExpression)axiom.getDomain()).accept(this.classVisitor));
    }

    @Override
    public OWLAxiom visit(OWLObjectPropertyRangeAxiom axiom) {
        return this.df.getOWLObjectPropertyRangeAxiom((OWLObjectPropertyExpression)axiom.getProperty(), ((OWLClassExpression)axiom.getRange()).accept(this.classVisitor));
    }

    @Override
    public OWLAxiom visit(OWLDisjointUnionAxiom axiom) {
        return this.df.getOWLDisjointUnionAxiom(axiom.getOWLClass(), OWLAPIStreamUtils.asList(axiom.classExpressions().map(p -> p.accept(this.classVisitor))));
    }

    @Override
    public OWLAxiom visit(OWLDataPropertyRangeAxiom axiom) {
        return this.df.getOWLDataPropertyRangeAxiom((OWLDataPropertyExpression)axiom.getProperty(), ((OWLDataRange)axiom.getRange()).accept(this.dataVisitor));
    }

    @Override
    public OWLAxiom visit(OWLClassAssertionAxiom axiom) {
        if (axiom.getClassExpression().isAnonymous()) {
            return this.df.getOWLClassAssertionAxiom(axiom.getClassExpression().accept(this.classVisitor), axiom.getIndividual());
        }
        return axiom;
    }

    @Override
    public OWLAxiom visit(OWLEquivalentClassesAxiom axiom) {
        return this.df.getOWLEquivalentClassesAxiom(axiom.classExpressions().map(p -> p.accept(this.classVisitor)));
    }

    class ClassVisitor
    implements OWLClassExpressionVisitorEx<OWLClassExpression> {
        ClassVisitor() {
        }

        private OWLClassExpression getNegation(OWLClassExpression classExpression) {
            return NNF.this.df.getOWLObjectComplementOf(classExpression);
        }

        @Override
        public OWLClassExpression visit(OWLClass ce) {
            if (NNF.this.negated) {
                if (ce.isOWLNothing()) {
                    return NNF.this.df.getOWLThing();
                }
                if (ce.isOWLThing()) {
                    return NNF.this.df.getOWLNothing();
                }
                return this.getNegation(ce);
            }
            return ce;
        }

        @Override
        public OWLClassExpression visit(OWLObjectIntersectionOf ce) {
            Stream<OWLClassExpression> ops = ce.operands().map(p -> p.accept(this));
            if (NNF.this.negated) {
                return NNF.this.df.getOWLObjectUnionOf(ops);
            }
            return NNF.this.df.getOWLObjectIntersectionOf(ops);
        }

        @Override
        public OWLClassExpression visit(OWLObjectUnionOf ce) {
            Stream<OWLClassExpression> ops = ce.operands().map(p -> p.accept(this));
            if (NNF.this.negated) {
                return NNF.this.df.getOWLObjectIntersectionOf(ops);
            }
            return NNF.this.df.getOWLObjectUnionOf(ops);
        }

        @Override
        public OWLClassExpression visit(OWLObjectComplementOf ce) {
            if (NNF.this.negated) {
                boolean neg = NNF.this.negated;
                NNF.this.negated = false;
                OWLClassExpression negDesc = ce.getOperand().accept(this);
                NNF.this.negated = neg;
                return negDesc;
            }
            boolean neg = NNF.this.negated;
            NNF.this.negated = true;
            OWLClassExpression negDesc = ce.getOperand().accept(this);
            NNF.this.negated = neg;
            return negDesc;
        }

        @Override
        public OWLClassExpression visit(OWLObjectSomeValuesFrom ce) {
            OWLClassExpression filler = ((OWLClassExpression)ce.getFiller()).accept(this);
            if (NNF.this.negated) {
                return NNF.this.df.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)ce.getProperty(), filler);
            }
            return NNF.this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)ce.getProperty(), filler);
        }

        @Override
        public OWLClassExpression visit(OWLObjectAllValuesFrom ce) {
            OWLClassExpression filler = ((OWLClassExpression)ce.getFiller()).accept(this);
            if (NNF.this.negated) {
                return NNF.this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)ce.getProperty(), filler);
            }
            return NNF.this.df.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)ce.getProperty(), filler);
        }

        @Override
        public OWLClassExpression visit(OWLObjectHasValue ce) {
            return ce.asSomeValuesFrom().accept(this);
        }

        @Override
        public OWLClassExpression visit(OWLObjectMinCardinality ce) {
            boolean neg = NNF.this.negated;
            int card = ce.getCardinality();
            if (NNF.this.negated && (card = ce.getCardinality() - 1) < 0) {
                card = 0;
            }
            NNF.this.negated = false;
            OWLClassExpression filler = ((OWLClassExpression)ce.getFiller()).accept(this);
            NNF.this.negated = neg;
            if (neg) {
                return NNF.this.df.getOWLObjectMaxCardinality(card, (OWLObjectPropertyExpression)ce.getProperty(), filler);
            }
            return NNF.this.df.getOWLObjectMinCardinality(card, (OWLObjectPropertyExpression)ce.getProperty(), filler);
        }

        @Override
        public OWLClassExpression visit(OWLObjectExactCardinality ce) {
            return ce.asIntersectionOfMinMax().accept(this);
        }

        @Override
        public OWLClassExpression visit(OWLObjectMaxCardinality ce) {
            boolean neg = NNF.this.negated;
            int card = ce.getCardinality();
            if (NNF.this.negated) {
                card = ce.getCardinality() + 1;
            }
            NNF.this.negated = false;
            OWLClassExpression filler = ((OWLClassExpression)ce.getFiller()).accept(this);
            NNF.this.negated = neg;
            if (neg) {
                return NNF.this.df.getOWLObjectMinCardinality(card, (OWLObjectPropertyExpression)ce.getProperty(), filler);
            }
            return NNF.this.df.getOWLObjectMaxCardinality(card, (OWLObjectPropertyExpression)ce.getProperty(), filler);
        }

        @Override
        public OWLClassExpression visit(OWLObjectHasSelf ce) {
            if (NNF.this.negated) {
                return this.getNegation(ce);
            }
            return ce;
        }

        @Override
        public OWLClassExpression visit(OWLObjectOneOf ce) {
            if (ce.individuals().count() == 1L) {
                if (NNF.this.negated) {
                    return this.getNegation(ce);
                }
                return ce;
            }
            return ce.asObjectUnionOf().accept(this);
        }

        @Override
        public OWLClassExpression visit(OWLDataSomeValuesFrom ce) {
            OWLDataRange filler = ((OWLDataRange)ce.getFiller()).accept(NNF.this.dataVisitor);
            if (NNF.this.negated) {
                return NNF.this.df.getOWLDataAllValuesFrom((OWLDataPropertyExpression)ce.getProperty(), filler);
            }
            return NNF.this.df.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)ce.getProperty(), filler);
        }

        @Override
        public OWLClassExpression visit(OWLDataAllValuesFrom ce) {
            OWLDataRange filler = ((OWLDataRange)ce.getFiller()).accept(NNF.this.dataVisitor);
            if (NNF.this.negated) {
                return NNF.this.df.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)ce.getProperty(), filler);
            }
            return NNF.this.df.getOWLDataAllValuesFrom((OWLDataPropertyExpression)ce.getProperty(), filler);
        }

        @Override
        public OWLClassExpression visit(OWLDataHasValue ce) {
            return ce.asSomeValuesFrom().accept(this);
        }

        @Override
        public OWLClassExpression visit(OWLDataExactCardinality ce) {
            return ce.asIntersectionOfMinMax().accept(this);
        }

        @Override
        public OWLClassExpression visit(OWLDataMaxCardinality ce) {
            boolean neg = NNF.this.negated;
            int card = ce.getCardinality();
            if (NNF.this.negated) {
                card = ce.getCardinality() + 1;
            }
            NNF.this.negated = false;
            OWLDataRange filler = ((OWLDataRange)ce.getFiller()).accept(NNF.this.dataVisitor);
            NNF.this.negated = neg;
            if (neg) {
                return NNF.this.df.getOWLDataMinCardinality(card, (OWLDataPropertyExpression)ce.getProperty(), filler);
            }
            return NNF.this.df.getOWLDataMaxCardinality(card, (OWLDataPropertyExpression)ce.getProperty(), filler);
        }

        @Override
        public OWLClassExpression visit(OWLDataMinCardinality ce) {
            boolean neg = NNF.this.negated;
            int card = ce.getCardinality();
            if (NNF.this.negated && (card = ce.getCardinality() - 1) < 0) {
                card = 0;
            }
            NNF.this.negated = false;
            OWLDataRange filler = ((OWLDataRange)ce.getFiller()).accept(NNF.this.dataVisitor);
            NNF.this.negated = neg;
            if (neg) {
                return NNF.this.df.getOWLDataMaxCardinality(card, (OWLDataPropertyExpression)ce.getProperty(), filler);
            }
            return NNF.this.df.getOWLDataMinCardinality(card, (OWLDataPropertyExpression)ce.getProperty(), filler);
        }
    }

    class DataVisitor
    implements OWLDataRangeVisitorEx<OWLDataRange> {
        DataVisitor() {
        }

        @Override
        public OWLDataRange visit(OWLDatatype node) {
            if (NNF.this.negated) {
                return NNF.this.df.getOWLDataComplementOf(node);
            }
            return node;
        }

        @Override
        public OWLDataRange visit(OWLDataComplementOf node) {
            if (NNF.this.negated) {
                return node.getDataRange();
            }
            return node;
        }

        @Override
        public OWLDataRange visit(OWLDataOneOf node) {
            if (node.values().count() == 1L) {
                if (NNF.this.negated) {
                    return NNF.this.df.getOWLDataComplementOf(node);
                }
                return node;
            }
            return NNF.this.df.getOWLDataUnionOf(node.values().map(oWLLiteral -> NNF.this.df.getOWLDataOneOf((OWLLiteral)oWLLiteral))).accept(this);
        }

        @Override
        public OWLDataRange visit(OWLDataIntersectionOf node) {
            Stream<OWLDataRange> ops = node.operands().map(p -> p.accept(this));
            if (NNF.this.negated) {
                return NNF.this.df.getOWLDataUnionOf(ops);
            }
            return NNF.this.df.getOWLDataIntersectionOf(ops);
        }

        @Override
        public OWLDataRange visit(OWLDataUnionOf node) {
            Stream<OWLDataRange> ops = node.operands().map(p -> p.accept(this));
            if (NNF.this.negated) {
                return NNF.this.df.getOWLDataIntersectionOf(ops);
            }
            return NNF.this.df.getOWLDataUnionOf(ops);
        }

        @Override
        public OWLDataRange visit(OWLDatatypeRestriction node) {
            if (NNF.this.negated) {
                return NNF.this.df.getOWLDataComplementOf(node);
            }
            return node;
        }
    }
}

