/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import com.google.common.base.Splitter;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.util.IRIShortFormProvider;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.vocab.Namespaces;

public class OntologyIRIShortFormProvider
implements IRIShortFormProvider {
    private static final String OWL_EXTENSION = ".owl";
    private static final String RDF_EXTENSION = ".rdf";
    private static final String XML_EXTENSION = ".xml";
    private static final String OBO_EXTENSION = ".obo";
    private static final String[] EXTENSIONS = new String[]{".owl", ".rdf", ".xml", ".obo"};
    private static final Map<IRI, String> WELL_KNOWN_SHORTFORMS = OntologyIRIShortFormProvider.initWellKnownShortForms();

    private static Map<IRI, String> initWellKnownShortForms() {
        HashMap<IRI, String> map = new HashMap<IRI, String>();
        Namespaces[] namespacesArray = Namespaces.values();
        int n = namespacesArray.length;
        int n2 = 0;
        while (n2 < n) {
            Namespaces ns = namespacesArray[n2];
            String iriPrefix = ns.getPrefixIRI();
            String iri = iriPrefix.endsWith("#") || iriPrefix.endsWith("/") ? iriPrefix.substring(0, iriPrefix.length() - 1) : iriPrefix;
            map.put(IRI.create(iri, ""), ns.getPrefixName().toLowerCase());
            map.put(IRI.create(String.valueOf(iri) + '/', ""), ns.getPrefixName().toLowerCase());
            ++n2;
        }
        return Collections.unmodifiableMap(map);
    }

    @Nullable
    private static String getWellKnownShortForm(IRI iri) {
        String wellKnownShortForm = WELL_KNOWN_SHORTFORMS.get(iri);
        if (wellKnownShortForm != null) {
            return wellKnownShortForm;
        }
        return null;
    }

    private static String stripExtensionIfPresent(String shortForm) {
        String lowerCaseShortForm = shortForm.toLowerCase();
        String[] stringArray = EXTENSIONS;
        int n = EXTENSIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String extension = stringArray[n2];
            if (lowerCaseShortForm.endsWith(extension)) {
                return shortForm.substring(0, shortForm.length() - extension.length());
            }
            ++n2;
        }
        return shortForm;
    }

    private static boolean isCandidatePathElement(String pathElement) {
        return !pathElement.isEmpty() && !OntologyIRIShortFormProvider.isVersionString(pathElement);
    }

    private static boolean isVersionString(String s) {
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            if (!OntologyIRIShortFormProvider.isVersionStringChar(ch)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isVersionStringChar(char ch) {
        return OntologyIRIShortFormProvider.isDigit(ch) || ch == '.' || ch == 'v';
    }

    private static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public String getShortForm(OWLOntology ont) {
        OWLOntologyID ontologyID = ont.getOntologyID();
        if (ontologyID.getOntologyIRI().isPresent()) {
            return this.getShortForm(OWLAPIPreconditions.verifyNotNull(ontologyID.getOntologyIRI().get()));
        }
        return ontologyID.toString();
    }

    @Override
    public String getShortForm(IRI iri) {
        String wellKnownShortForm = OntologyIRIShortFormProvider.getWellKnownShortForm(iri);
        if (wellKnownShortForm != null) {
            return wellKnownShortForm;
        }
        URI uri = iri.toURI();
        String path = uri.getPath();
        if (path != null && !path.isEmpty()) {
            String candidatePathElement = "";
            for (String tok : Splitter.on((char)'/').split((CharSequence)path)) {
                if (!OntologyIRIShortFormProvider.isCandidatePathElement(tok)) continue;
                candidatePathElement = OntologyIRIShortFormProvider.stripExtensionIfPresent(tok);
            }
            return candidatePathElement;
        }
        if (uri.getHost() != null) {
            return iri.toString();
        }
        return iri.toString();
    }
}

