/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import com.google.common.base.Splitter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.annotations.HasPriority;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyIRIMapper;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.SAXParsers;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.semanticweb.owlapi.vocab.OWLXMLVocabulary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@HasPriority(value=1.0)
public class ZipIRIMapper
extends DefaultHandler
implements OWLOntologyIRIMapper,
Serializable {
    static final Pattern pattern = Pattern.compile("Ontology\\(<([^>]+)>");
    private static final Logger LOGGER = LoggerFactory.getLogger(ZipIRIMapper.class);
    private final Set<String> fileExtensions = new HashSet<String>(Arrays.asList(".owl", ".xml", ".rdf", ".omn", ".ofn", ".obo"));
    private final Map<String, OntologyRootElementHandler> handlerMap = CollectionFactory.createMap();
    private final Map<IRI, IRI> ontologyIRI2PhysicalURIMap = CollectionFactory.createMap();
    private final Map<String, IRI> oboFileMap = CollectionFactory.createMap();
    @Nullable
    private IRI currentFile;

    public ZipIRIMapper(File zip, String baseIRI) throws IOException {
        this(new ZipFile(zip), baseIRI);
    }

    public ZipIRIMapper(ZipFile zip, String baseIRI) throws IOException {
        this.handlerMap.put((Object)((Object)Namespaces.RDF) + "RDF", this::baseIRI);
        this.handlerMap.put(OWLXMLVocabulary.ONTOLOGY.toString(), this::ontologyIRI);
        this.processFile(zip, baseIRI);
    }

    @Nullable
    protected IRI ontologyIRI(Attributes attributes) {
        String ontURI = attributes.getValue(Namespaces.OWL.toString(), "ontologyIRI");
        if (ontURI == null) {
            ontURI = attributes.getValue("ontologyIRI");
        }
        if (ontURI == null) {
            return null;
        }
        return IRI.create(ontURI);
    }

    @Nullable
    protected IRI baseIRI(Attributes attributes) {
        String baseValue = attributes.getValue(Namespaces.XML.toString(), "base");
        if (baseValue == null) {
            return null;
        }
        return IRI.create(baseValue);
    }

    static IRI unquote(String tok) {
        String substring = tok.substring(1, tok.length() - 1);
        assert (substring != null);
        return IRI.create(substring);
    }

    public Set<String> getFileExtensions() {
        return new HashSet<String>(this.fileExtensions);
    }

    public void setFileExtensions(Collection<String> extensions) {
        this.fileExtensions.clear();
        this.fileExtensions.addAll(extensions);
    }

    public Stream<Map.Entry<IRI, IRI>> mappedEntries() {
        return this.ontologyIRI2PhysicalURIMap.entrySet().stream();
    }

    @Override
    @Nullable
    public IRI getDocumentIRI(IRI ontologyIRI) {
        int lastSepIndex;
        String name;
        IRI documentIRI;
        String path;
        if (ontologyIRI.toString().endsWith(".obo") && (path = ontologyIRI.toURI().getPath()) != null && (documentIRI = this.oboFileMap.get(name = path.substring((lastSepIndex = path.lastIndexOf(47)) + 1, path.length()))) != null) {
            return documentIRI;
        }
        return this.ontologyIRI2PhysicalURIMap.get(ontologyIRI);
    }

    public Stream<Map.Entry<String, IRI>> oboMappings() {
        return this.oboFileMap.entrySet().stream();
    }

    public Stream<Map.Entry<IRI, IRI>> iriMappings() {
        return this.ontologyIRI2PhysicalURIMap.entrySet().stream();
    }

    private void processFile(ZipFile archive, String baseIRI) throws IOException {
        Enumeration<? extends ZipEntry> entries = archive.entries();
        while (entries.hasMoreElements()) {
            this.parseIfExtensionSupported(archive, entries.nextElement(), baseIRI);
        }
    }

    protected void parseIfExtensionSupported(ZipFile file, ZipEntry e, String baseIRI) throws IOException {
        String name = e.getName();
        int lastIndexOf = name.lastIndexOf(46);
        if (lastIndexOf < 0) {
            return;
        }
        IRI physicalIRI = IRI.create(String.valueOf(baseIRI) + name);
        String extension = name.substring(lastIndexOf);
        if (".obo".equals(extension)) {
            this.oboFileMap.put(name, physicalIRI);
        } else {
            Throwable throwable = null;
            Object var9_10 = null;
            try (InputStream in = file.getInputStream(e);){
                IRI logical;
                if (".ofn".equals(extension)) {
                    IRI logical2 = ZipIRIMapper.parseFSSFile(in);
                    if (logical2 != null) {
                        this.ontologyIRI2PhysicalURIMap.put(logical2, physicalIRI);
                    }
                } else if (".omn".equals(extension)) {
                    IRI logical3 = ZipIRIMapper.parseManchesterSyntaxFile(in);
                    if (logical3 != null) {
                        this.ontologyIRI2PhysicalURIMap.put(logical3, physicalIRI);
                    }
                } else if (this.fileExtensions.contains(extension) && (logical = this.parseFile(in)) != null) {
                    this.ontologyIRI2PhysicalURIMap.put(logical, physicalIRI);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Nullable
    private static IRI parseFSSFile(InputStream input) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 10[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    private IRI parseFile(InputStream file) {
        try {
            this.currentFile = null;
            SAXParsers.initParserWithOWLAPIStandards(null, "64000").parse(file, (DefaultHandler)this);
        }
        catch (IOException | SAXException e) {
            LOGGER.debug("Exception reading file", (Throwable)e);
        }
        return this.currentFile;
    }

    /*
     * Exception decompiling
     */
    @Nullable
    private static IRI parseManchesterSyntaxFile(InputStream input) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 10[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    private static IRI parseManLine(String line) {
        for (String tok : Splitter.on((String)" ").split((CharSequence)line)) {
            if (!tok.startsWith("<") || !tok.endsWith(">")) continue;
            return ZipIRIMapper.unquote(tok);
        }
        return null;
    }

    @Override
    public void startElement(@Nullable String uri, @Nullable String localName, @Nullable String qName, @Nullable Attributes attributes) throws SAXException {
        OntologyRootElementHandler handler = this.handlerMap.get(String.valueOf(uri) + localName);
        if (handler != null) {
            IRI ontologyIRI = handler.handle(OWLAPIPreconditions.checkNotNull(attributes));
            if (ontologyIRI != null && this.currentFile == null) {
                this.currentFile = ontologyIRI;
            }
            throw new SAXException();
        }
    }

    protected void addMapping(IRI ontologyIRI, File file) {
        this.ontologyIRI2PhysicalURIMap.put(ontologyIRI, IRI.create(file));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AutoIRIMapper: (");
        sb.append(this.ontologyIRI2PhysicalURIMap.size()).append(" ontologies)\n");
        this.ontologyIRI2PhysicalURIMap.forEach((k, v) -> {
            StringBuilder stringBuilder2 = sb.append("    ").append(k.toQuotedString()).append(" -> ").append((CharSequence)v).append('\n');
        });
        return sb.toString();
    }

    @FunctionalInterface
    private static interface OntologyRootElementHandler
    extends Serializable {
        @Nullable
        public IRI handle(Attributes var1);
    }
}

