/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.change;

import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.stream.Stream;
import org.semanticweb.owlapi.change.AbstractCompositeOntologyChange;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public class ConvertEquivalentClassesToSuperClasses
extends AbstractCompositeOntologyChange {
    private static final OWLClassExpressionVisitorEx<Stream<? extends OWLClassExpression>> INTERSECTION_SPLITTER = new OWLClassExpressionVisitorEx<Stream<? extends OWLClassExpression>>(){

        @Override
        public Stream<? extends OWLClassExpression> visit(OWLObjectIntersectionOf ce) {
            return ce.operands();
        }

        @Override
        public Stream<? extends OWLClassExpression> doDefault(Object o) {
            return OWLAPIStreamUtils.empty();
        }
    };
    private final OWLOntology targetOntology;
    private final OWLClass cls;
    private final Collection<OWLOntology> ontologies;
    private final boolean splitIntersections;

    public ConvertEquivalentClassesToSuperClasses(OWLDataFactory dataFactory, OWLClass cls, Collection<OWLOntology> ontologies, OWLOntology targetOntology, boolean splitIntersections) {
        super(dataFactory);
        this.targetOntology = OWLAPIPreconditions.checkNotNull(targetOntology, "targetOntology cannot be null");
        this.cls = OWLAPIPreconditions.checkNotNull(cls, "cls cannot be null");
        this.ontologies = OWLAPIPreconditions.checkNotNull(ontologies, "ontologies cannot be null");
        this.splitIntersections = splitIntersections;
        this.generateChanges();
    }

    private void generateChanges() {
        HashSet supers = new HashSet();
        for (OWLOntology o : this.ontologies) {
            o.equivalentClassesAxioms(this.cls).forEach(ax -> {
                this.addChange(new RemoveAxiom(o, (OWLAxiom)ax));
                ax.classExpressions().forEach(c -> this.collectClassExpressions((OWLClassExpression)c, supers));
            });
        }
        supers.remove(this.cls);
        supers.forEach(sup -> this.addChange(new AddAxiom(this.targetOntology, this.df.getOWLSubClassOfAxiom(this.cls, (OWLClassExpression)sup))));
    }

    private void collectClassExpressions(OWLClassExpression desc, Collection<OWLClassExpression> supers) {
        if (!this.splitIntersections) {
            supers.add(desc);
            return;
        }
        Iterator iterator = desc.accept(INTERSECTION_SPLITTER).iterator();
        if (iterator.hasNext()) {
            Iterators.addAll(supers, iterator);
        } else {
            supers.add(desc);
        }
    }
}

