/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.io.Serializable;
import java.util.Set;
import java.util.stream.Stream;
import org.semanticweb.owlapi.io.OWLOntologyLoaderMetaData;
import org.semanticweb.owlapi.io.RDFOntologyHeaderStatus;
import org.semanticweb.owlapi.io.RDFTriple;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class RDFParserMetaData
implements OWLOntologyLoaderMetaData,
Serializable {
    private final int tripleCount;
    private final RDFOntologyHeaderStatus headerStatus;
    private final Set<RDFTriple> unparsedTriples;
    private final ArrayListMultimap<IRI, Class<?>> guessedDeclarations;

    public RDFParserMetaData(RDFOntologyHeaderStatus headerStatus, int tripleCount, Set<RDFTriple> unparsedTriples, ArrayListMultimap<IRI, Class<?>> guessedDeclarations) {
        this.tripleCount = tripleCount;
        this.headerStatus = OWLAPIPreconditions.checkNotNull(headerStatus, "headerStatus cannot be null");
        this.unparsedTriples = OWLAPIPreconditions.checkNotNull(unparsedTriples, "unparsedTriples cannot be null");
        this.guessedDeclarations = OWLAPIPreconditions.checkNotNull(guessedDeclarations, "guessedDeclarations cannot be null");
    }

    @Override
    public int getTripleCount() {
        return this.tripleCount;
    }

    @Override
    public RDFOntologyHeaderStatus getHeaderState() {
        return this.headerStatus;
    }

    @Override
    public Stream<RDFTriple> getUnparsedTriples() {
        return this.unparsedTriples.stream();
    }

    @Override
    public Multimap<IRI, Class<?>> getGuessedDeclarations() {
        return Multimaps.unmodifiableMultimap(this.guessedDeclarations);
    }
}

