/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.apibinding;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntologyBuilder;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyManagerFactory;
import org.semanticweb.owlapi.util.mansyntax.ManchesterOWLSyntaxParser;
import org.semanticweb.owlapi.utilities.Injector;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryImpl;
import uk.ac.manchester.cs.owl.owlapi.concurrent.ConcurrentOWLOntologyBuilder;
import uk.ac.manchester.cs.owl.owlapi.concurrent.NoOpReadWriteLock;
import uk.ac.manchester.cs.owl.owlapi.concurrent.NonConcurrentOWLOntologyBuilder;

public class OWLManager
implements OWLOntologyManagerFactory {
    private static final Injector concurrentInjector = InjectorConstants.REENTRANT.init(OWLManager.configure(new Injector()));
    private static final Injector normalInjector = InjectorConstants.NOOP.init(OWLManager.configure(new Injector()));

    private static Injector configure(Injector i) {
        Arrays.stream(InjectorConstants.values()).forEach(f -> f.init(i));
        return i;
    }

    public static OWLOntologyManager createOWLOntologyManager() {
        return (OWLOntologyManager)normalInjector.inject(normalInjector.getImplementation(OWLOntologyManager.class, new Annotation[0]));
    }

    public static OWLOntologyManager createConcurrentOWLOntologyManager() {
        return (OWLOntologyManager)concurrentInjector.inject(concurrentInjector.getImplementation(OWLOntologyManager.class, new Annotation[0]));
    }

    public static OWLDataFactory getOWLDataFactory(OWLOntologyLoaderConfiguration config) {
        return new OWLDataFactoryImpl(config);
    }

    public static OWLDataFactory getOWLDataFactory() {
        return OWLManager.getOWLDataFactory(new OWLOntologyLoaderConfiguration());
    }

    public static ManchesterOWLSyntaxParser createManchesterParser() {
        return (ManchesterOWLSyntaxParser)normalInjector.getImplementation(ManchesterOWLSyntaxParser.class, new Annotation[0]);
    }

    public OWLOntologyManager get() {
        return OWLManager.createOWLOntologyManager();
    }

    static enum InjectorConstants {
        COMPRESSION_ENABLED(Boolean.class, () -> Boolean.FALSE),
        CONCURRENTBUILDER(OWLOntologyBuilder.class, ConcurrentOWLOntologyBuilder.class),
        NONCONCURRENTBUILDER(OWLOntologyBuilder.class, NonConcurrentOWLOntologyBuilder.class),
        REENTRANT(ReadWriteLock.class, () -> new ReentrantReadWriteLock()),
        NOOP(ReadWriteLock.class, new NoOpReadWriteLock());

        private Class<?> c;
        private Supplier<?> s;
        private Class<?> type;
        private Object instance;

        private InjectorConstants(Class<?> c, Supplier<?> s) {
            this.c = c;
            this.s = s;
        }

        private InjectorConstants(Class<?> c, Object s) {
            this.c = c;
            this.instance = s;
        }

        private InjectorConstants(Class<?> c, Class<?> t) {
            this.c = c;
            this.type = t;
        }

        Annotation[] anns() {
            try {
                return InjectorConstants.class.getField(this.name()).getAnnotations();
            }
            catch (NoSuchFieldException | SecurityException e) {
                throw new RuntimeException(e);
            }
        }

        Injector init(Injector i) {
            if (this.instance != null) {
                i.bindToOne(this.instance, this.c, this.anns());
            } else if (this.s != null) {
                i.bindToOne(this.s, this.c, this.anns());
            } else {
                i.bind(this.type, this.c, this.anns());
            }
            return i;
        }
    }
}

